/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.PutFilterResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutFilterRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String description;
    private final String filterId;
    private final List<String> items;
    public static final JsonpDeserializer<PutFilterRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutFilterRequest::setupPutFilterRequestDeserializer);
    public static final Endpoint<PutFilterRequest, PutFilterResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutFilterRequest, PutFilterResponse>("es/ml.put_filter", request -> "PUT", request -> {
        boolean _filterId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/filters");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.filterId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, PutFilterResponse._DESERIALIZER);

    private PutFilterRequest(Builder builder) {
        this.description = builder.description;
        this.filterId = ApiTypeHelper.requireNonNull(builder.filterId, this, "filterId");
        this.items = ApiTypeHelper.unmodifiable(builder.items);
    }

    public static PutFilterRequest of(Function<Builder, ObjectBuilder<PutFilterRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    public final String filterId() {
        return this.filterId;
    }

    public final List<String> items() {
        return this.items;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (ApiTypeHelper.isDefined(this.items)) {
            generator.writeKey("items");
            generator.writeStartArray();
            for (String item0 : this.items) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    protected static void setupPutFilterRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::items, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "items");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<PutFilterRequest> {
        @Nullable
        private String description;
        private String filterId;
        @Nullable
        private List<String> items;

        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public final Builder filterId(String value) {
            this.filterId = value;
            return this;
        }

        public final Builder items(List<String> list) {
            this.items = Builder._listAddAll(this.items, list);
            return this;
        }

        public final Builder items(String value, String ... values) {
            this.items = Builder._listAdd(this.items, value, values);
            return this;
        }

        @Override
        public PutFilterRequest build() {
            this._checkSingleUse();
            return new PutFilterRequest(this);
        }
    }
}

