/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.Processor;
import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class JsonProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final boolean addToRoot;
    private final String field;
    private final String targetField;
    public static final JsonpDeserializer<JsonProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, JsonProcessor::setupJsonProcessorDeserializer);

    private JsonProcessor(Builder builder) {
        super(builder);
        this.addToRoot = ApiTypeHelper.requireNonNull(builder.addToRoot, this, "addToRoot");
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.targetField = ApiTypeHelper.requireNonNull(builder.targetField, this, "targetField");
    }

    public static JsonProcessor of(Function<Builder, ObjectBuilder<JsonProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.Json;
    }

    public final boolean addToRoot() {
        return this.addToRoot;
    }

    public final String field() {
        return this.field;
    }

    public final String targetField() {
        return this.targetField;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("add_to_root");
        generator.write(this.addToRoot);
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("target_field");
        generator.write(this.targetField);
    }

    protected static void setupJsonProcessorDeserializer(ObjectDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::addToRoot, JsonpDeserializer.booleanDeserializer(), "add_to_root");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::targetField, JsonpDeserializer.stringDeserializer(), "target_field");
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<JsonProcessor> {
        private Boolean addToRoot;
        private String field;
        private String targetField;

        public final Builder addToRoot(boolean value) {
            this.addToRoot = value;
            return this;
        }

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder targetField(String value) {
            this.targetField = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public JsonProcessor build() {
            this._checkSingleUse();
            return new JsonProcessor(this);
        }
    }
}

