/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.enrich;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class EnrichPolicy
implements JsonpSerializable {
    private final List<String> enrichFields;
    private final List<String> indices;
    private final String matchField;
    @Nullable
    private final String query;
    @Nullable
    private final String name;
    public static final JsonpDeserializer<EnrichPolicy> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, EnrichPolicy::setupEnrichPolicyDeserializer);

    private EnrichPolicy(Builder builder) {
        this.enrichFields = ApiTypeHelper.unmodifiableRequired(builder.enrichFields, (Object)this, "enrichFields");
        this.indices = ApiTypeHelper.unmodifiableRequired(builder.indices, (Object)this, "indices");
        this.matchField = ApiTypeHelper.requireNonNull(builder.matchField, this, "matchField");
        this.query = builder.query;
        this.name = builder.name;
    }

    public static EnrichPolicy of(Function<Builder, ObjectBuilder<EnrichPolicy>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> enrichFields() {
        return this.enrichFields;
    }

    public final List<String> indices() {
        return this.indices;
    }

    public final String matchField() {
        return this.matchField;
    }

    @Nullable
    public final String query() {
        return this.query;
    }

    @Nullable
    public final String name() {
        return this.name;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.enrichFields)) {
            generator.writeKey("enrich_fields");
            generator.writeStartArray();
            for (String item0 : this.enrichFields) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (String item0 : this.indices) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("match_field");
        generator.write(this.matchField);
        if (this.query != null) {
            generator.writeKey("query");
            generator.write(this.query);
        }
        if (this.name != null) {
            generator.writeKey("name");
            generator.write(this.name);
        }
    }

    protected static void setupEnrichPolicyDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::enrichFields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "enrich_fields");
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "indices");
        op.add(Builder::matchField, JsonpDeserializer.stringDeserializer(), "match_field");
        op.add(Builder::query, JsonpDeserializer.stringDeserializer(), "query");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<EnrichPolicy> {
        private List<String> enrichFields;
        private List<String> indices;
        private String matchField;
        @Nullable
        private String query;
        @Nullable
        private String name;

        public final Builder enrichFields(List<String> list) {
            this.enrichFields = Builder._listAddAll(this.enrichFields, list);
            return this;
        }

        public final Builder enrichFields(String value, String ... values) {
            this.enrichFields = Builder._listAdd(this.enrichFields, value, values);
            return this;
        }

        public final Builder indices(List<String> list) {
            this.indices = Builder._listAddAll(this.indices, list);
            return this;
        }

        public final Builder indices(String value, String ... values) {
            this.indices = Builder._listAdd(this.indices, value, values);
            return this;
        }

        public final Builder matchField(String value) {
            this.matchField = value;
            return this;
        }

        public final Builder query(@Nullable String value) {
            this.query = value;
            return this;
        }

        public final Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        @Override
        public EnrichPolicy build() {
            this._checkSingleUse();
            return new EnrichPolicy(this);
        }
    }
}

