/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.FieldDateMath;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DateRangeExpression
implements JsonpSerializable {
    @Nullable
    private final FieldDateMath from;
    @Nullable
    private final String key;
    @Nullable
    private final FieldDateMath to;
    public static final JsonpDeserializer<DateRangeExpression> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DateRangeExpression::setupDateRangeExpressionDeserializer);

    private DateRangeExpression(Builder builder) {
        this.from = builder.from;
        this.key = builder.key;
        this.to = builder.to;
    }

    public static DateRangeExpression of(Function<Builder, ObjectBuilder<DateRangeExpression>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final FieldDateMath from() {
        return this.from;
    }

    @Nullable
    public final String key() {
        return this.key;
    }

    @Nullable
    public final FieldDateMath to() {
        return this.to;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.from != null) {
            generator.writeKey("from");
            this.from.serialize(generator, mapper);
        }
        if (this.key != null) {
            generator.writeKey("key");
            generator.write(this.key);
        }
        if (this.to != null) {
            generator.writeKey("to");
            this.to.serialize(generator, mapper);
        }
    }

    protected static void setupDateRangeExpressionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::from, FieldDateMath._DESERIALIZER, "from");
        op.add(Builder::key, JsonpDeserializer.stringDeserializer(), "key");
        op.add(Builder::to, FieldDateMath._DESERIALIZER, "to");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<DateRangeExpression> {
        @Nullable
        private FieldDateMath from;
        @Nullable
        private String key;
        @Nullable
        private FieldDateMath to;

        public final Builder from(@Nullable FieldDateMath value) {
            this.from = value;
            return this;
        }

        public final Builder from(Function<FieldDateMath.Builder, ObjectBuilder<FieldDateMath>> fn) {
            return this.from(fn.apply(new FieldDateMath.Builder()).build());
        }

        public final Builder key(@Nullable String value) {
            this.key = value;
            return this;
        }

        public final Builder to(@Nullable FieldDateMath value) {
            this.to = value;
            return this;
        }

        public final Builder to(Function<FieldDateMath.Builder, ObjectBuilder<FieldDateMath>> fn) {
            return this.to(fn.apply(new FieldDateMath.Builder()).build());
        }

        @Override
        public DateRangeExpression build() {
            this._checkSingleUse();
            return new DateRangeExpression(this);
        }
    }
}

