/*
 * Decompiled with CFR 0.152.
 */
package com.apptasticsoftware.rssreader.filter;

import com.apptasticsoftware.rssreader.filter.FeedFilter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class InvalidXmlCharacterFilter
implements FeedFilter {
    @Override
    public InputStream filter(InputStream feedStream) {
        return new StreamingXmlFilterInputStream(feedStream);
    }

    private static class StreamingXmlFilterInputStream
    extends InputStream {
        private static final Map<String, String> HTML_ENTITIES = new HashMap<String, String>();
        private static final String CDATA_START = "<![CDATA[";
        private static final String CDATA_END = "]]>";
        private static final String QUOTE_ESCAPE = "&quot;";
        private final Reader reader;
        private final Charset charset;
        private final ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream(1024);
        private byte[] buffer = new byte[0];
        private int bufferPos = 0;
        private final StringBuilder entityBuffer = new StringBuilder();
        private final StringBuilder cdataBuffer = new StringBuilder();
        private boolean inEntity = false;
        private boolean inCDATA = false;
        private int cdataMatchPos = 0;
        private int cdataEndMatchPos = 0;

        public StreamingXmlFilterInputStream(InputStream inputStream) {
            this(inputStream, StandardCharsets.UTF_8);
        }

        public StreamingXmlFilterInputStream(InputStream inputStream, Charset charset) {
            this.reader = new InputStreamReader(inputStream, charset);
            this.charset = charset;
        }

        @Override
        public int read() throws IOException {
            if (this.bufferPos >= this.buffer.length) {
                this.refillBuffer();
                if (this.buffer.length == 0) {
                    return -1;
                }
            }
            return this.buffer[this.bufferPos++] & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int bytesRead = 0;
            while (len > 0) {
                if (this.bufferPos >= this.buffer.length) {
                    this.refillBuffer();
                    if (this.buffer.length == 0) {
                        return bytesRead == 0 ? -1 : bytesRead;
                    }
                }
                int toCopy = Math.min(len, this.buffer.length - this.bufferPos);
                System.arraycopy(this.buffer, this.bufferPos, b, off, toCopy);
                this.bufferPos += toCopy;
                off += toCopy;
                len -= toCopy;
                bytesRead += toCopy;
            }
            return bytesRead;
        }

        private void refillBuffer() throws IOException {
            this.byteBuffer.reset();
            this.entityBuffer.setLength(0);
            while (true) {
                int c;
                if ((c = this.reader.read()) == -1) {
                    if (this.inEntity && !this.inCDATA) {
                        this.writeStringToBuffer(this.entityBuffer.toString());
                    }
                    if (this.cdataBuffer.length() > 0) {
                        this.writeStringToBuffer(this.cdataBuffer.toString());
                    }
                    break;
                }
                char ch = (char)c;
                if (!this.isValidXmlChar(ch)) continue;
                if (!this.inCDATA && ch == CDATA_START.charAt(this.cdataMatchPos)) {
                    ++this.cdataMatchPos;
                    this.cdataBuffer.append(ch);
                    if (this.cdataMatchPos == CDATA_START.length()) {
                        this.inCDATA = true;
                        this.cdataMatchPos = 0;
                        this.writeStringToBuffer(this.cdataBuffer.toString());
                        this.cdataBuffer.setLength(0);
                        continue;
                    }
                } else if (!this.inCDATA && this.cdataMatchPos > 0) {
                    this.writeStringToBuffer(this.cdataBuffer.toString());
                    this.cdataBuffer.setLength(0);
                    this.cdataMatchPos = 0;
                    this.processRegularChar(ch);
                } else if (this.inCDATA) {
                    if (ch == CDATA_END.charAt(this.cdataEndMatchPos)) {
                        ++this.cdataEndMatchPos;
                        this.cdataBuffer.append(ch);
                        if (this.cdataEndMatchPos == CDATA_END.length()) {
                            this.inCDATA = false;
                            this.cdataEndMatchPos = 0;
                            this.writeStringToBuffer(this.cdataBuffer.toString());
                            this.cdataBuffer.setLength(0);
                        }
                    } else if (this.cdataEndMatchPos > 0) {
                        this.cdataBuffer.append(ch);
                        this.cdataEndMatchPos = 0;
                    } else {
                        this.writeStringToBuffer(String.valueOf(ch));
                    }
                } else {
                    this.processRegularChar(ch);
                }
                if (this.byteBuffer.size() > 0) break;
            }
            this.buffer = this.byteBuffer.toByteArray();
            this.bufferPos = 0;
        }

        private void processRegularChar(char ch) throws IOException {
            if (this.inEntity) {
                this.entityBuffer.append(ch);
                if (ch == ';') {
                    this.inEntity = false;
                    String entity = this.entityBuffer.toString();
                    if (entity.startsWith("&#")) {
                        this.writeStringToBuffer(entity);
                    } else {
                        String entityName = entity.substring(1, entity.length() - 1);
                        String replacement = HTML_ENTITIES.get(entityName);
                        this.writeStringToBuffer(Objects.requireNonNullElse(replacement, entity));
                    }
                    this.entityBuffer.setLength(0);
                }
            } else if (ch == '&') {
                this.inEntity = true;
                this.entityBuffer.setLength(0);
                this.entityBuffer.append(ch);
            } else if (this.isValidXmlChar(ch)) {
                this.writeStringToBuffer(String.valueOf(ch));
            }
        }

        private void writeStringToBuffer(String str) throws IOException {
            byte[] bytes = str.getBytes(this.charset);
            this.byteBuffer.write(bytes);
        }

        private boolean isValidXmlChar(char ch) {
            return ch == '\t' || ch == '\n' || ch == '\r' || ch >= ' ' && ch <= '\ud7ff' || ch >= '\ue000' && ch <= '\ufffd';
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }

        static {
            HTML_ENTITIES.put("amp", "&amp;");
            HTML_ENTITIES.put("lt", "&lt;");
            HTML_ENTITIES.put("gt", "&gt;");
            HTML_ENTITIES.put("apos", "&apos;");
            HTML_ENTITIES.put("quot", QUOTE_ESCAPE);
            HTML_ENTITIES.put("ldquo", QUOTE_ESCAPE);
            HTML_ENTITIES.put("rdquo", QUOTE_ESCAPE);
            HTML_ENTITIES.put("rsquo", QUOTE_ESCAPE);
            HTML_ENTITIES.put("auml", "&#228;");
            HTML_ENTITIES.put("ouml", "&#246;");
            HTML_ENTITIES.put("uuml", "&#252;");
            HTML_ENTITIES.put("Auml", "&#196;");
            HTML_ENTITIES.put("Ouml", "&#214;");
            HTML_ENTITIES.put("Uuml", "&#220;");
            HTML_ENTITIES.put("aacute", "&#225;");
            HTML_ENTITIES.put("eacute", "&#233;");
            HTML_ENTITIES.put("iacute", "&#237;");
            HTML_ENTITIES.put("oacute", "&#243;");
            HTML_ENTITIES.put("uacute", "&#250;");
        }
    }
}

