/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class WeightedAverageValue
implements PlainJsonSerializable {
    @Nullable
    private final String field;
    @Nullable
    private final Double missing;
    @Nullable
    private final Script script;
    public static final JsonpDeserializer<WeightedAverageValue> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, WeightedAverageValue::setupWeightedAverageValueDeserializer);

    private WeightedAverageValue(Builder builder) {
        this.field = builder.field;
        this.missing = builder.missing;
        this.script = builder.script;
    }

    public static WeightedAverageValue of(Function<Builder, ObjectBuilder<WeightedAverageValue>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String field() {
        return this.field;
    }

    @Nullable
    public final Double missing() {
        return this.missing;
    }

    @Nullable
    public final Script script() {
        return this.script;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.missing != null) {
            generator.writeKey("missing");
            generator.write(this.missing.doubleValue());
        }
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
    }

    protected static void setupWeightedAverageValueDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::missing, JsonpDeserializer.doubleDeserializer(), "missing");
        op.add(Builder::script, Script._DESERIALIZER, "script");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<WeightedAverageValue> {
        @Nullable
        private String field;
        @Nullable
        private Double missing;
        @Nullable
        private Script script;

        public final Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        public final Builder missing(@Nullable Double value) {
            this.missing = value;
            return this;
        }

        public final Builder script(@Nullable Script value) {
            this.script = value;
            return this;
        }

        public final Builder script(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.script(fn.apply(new Script.Builder()).build());
        }

        @Override
        public WeightedAverageValue build() {
            this._checkSingleUse();
            return new WeightedAverageValue(this);
        }
    }
}

