/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.otel_apm_service_map.model.internal;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.opensearch.dataprepper.plugins.otel.common.OTelSpanDerivationUtil;

public class SpanStateData
implements Serializable {
    private String serviceName;
    private String spanId;
    private String parentSpanId;
    private String traceId;
    private String spanKind;
    private String spanName;
    private String operation;
    private Long durationInNanos;
    private String status;
    private String endTime;
    private int error;
    private int fault;
    private String operationName;
    private String environment;
    private Map<String, String> groupByAttributes;

    public SpanStateData(String serviceName, String spanId, String parentSpanId, String traceId, String spanKind, String spanName, String operation, Long durationInNanos, String status, String endTime, Map<String, String> groupByAttributes, Map<String, Object> spanAttributes) {
        this.serviceName = serviceName;
        this.spanId = spanId;
        this.parentSpanId = parentSpanId;
        this.traceId = traceId;
        this.spanKind = spanKind;
        this.spanName = spanName;
        this.operation = operation;
        this.durationInNanos = durationInNanos;
        this.status = status;
        this.endTime = endTime;
        this.groupByAttributes = groupByAttributes != null ? groupByAttributes : Collections.emptyMap();
        OTelSpanDerivationUtil.ErrorFaultResult errorFault = OTelSpanDerivationUtil.computeErrorAndFault((Object)status, spanAttributes);
        this.error = errorFault.getError();
        this.fault = errorFault.getFault();
        this.operationName = OTelSpanDerivationUtil.computeOperationName((String)spanName, spanAttributes);
        this.environment = OTelSpanDerivationUtil.computeEnvironment(spanAttributes);
    }

    public int getError() {
        return this.error;
    }

    public int getFault() {
        return this.fault;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public String getEnvironment() {
        return this.environment;
    }

    private String extractFirstPathSection(String path) {
        if (path == null || path.isEmpty()) {
            return "/";
        }
        Object normalizedPath = path.startsWith("/") ? path : "/" + path;
        int secondSlashIndex = ((String)normalizedPath).indexOf(47, 1);
        if (secondSlashIndex == -1) {
            return normalizedPath;
        }
        return ((String)normalizedPath).substring(0, secondSlashIndex);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpanStateData that = (SpanStateData)o;
        return Objects.equals(this.serviceName, that.serviceName) && Objects.equals(this.spanId, that.spanId) && Objects.equals(this.traceId, that.traceId) && Objects.equals(this.parentSpanId, that.parentSpanId) && Objects.equals(this.spanKind, that.spanKind) && Objects.equals(this.spanName, that.spanName) && Objects.equals(this.operation, that.operation);
    }

    public int hashCode() {
        int result = Objects.hash(this.serviceName, this.spanKind, this.spanName, this.operation);
        result = 31 * result + (this.spanId == null ? 0 : this.spanId.hashCode());
        result = 31 * result + (this.parentSpanId == null ? 0 : this.parentSpanId.hashCode());
        result = 31 * result + (this.traceId == null ? 0 : this.traceId.hashCode());
        return result;
    }

    @VisibleForTesting
    public void setDurationInNanos(Long duration) {
        this.durationInNanos = duration;
    }

    @VisibleForTesting
    public void setStatus(String status) {
        this.status = status;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getSpanId() {
        return this.spanId;
    }

    public String getParentSpanId() {
        return this.parentSpanId;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public String getSpanKind() {
        return this.spanKind;
    }

    public String getSpanName() {
        return this.spanName;
    }

    public String getOperation() {
        return this.operation;
    }

    public Long getDurationInNanos() {
        return this.durationInNanos;
    }

    public String getStatus() {
        return this.status;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public Map<String, String> getGroupByAttributes() {
        return this.groupByAttributes;
    }
}

