/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.otel_apm_service_map.model.internal;

import java.util.ArrayList;
import java.util.List;
import org.opensearch.dataprepper.model.metric.Exemplar;

public class MetricAggregationState {
    private long requestCount = 0L;
    private long errorCount = 0L;
    private long faultCount = 0L;
    private final List<Exemplar> errorExemplars = new ArrayList<Exemplar>();
    private final List<Exemplar> faultExemplars = new ArrayList<Exemplar>();
    private final List<Double> latencyDurations = new ArrayList<Double>();

    public MetricAggregationState() {
        this(0L, 0L, 0L);
    }

    public MetricAggregationState(long requestCount, long errorCount, long faultCount) {
        this.requestCount = requestCount;
        this.errorCount = errorCount;
        this.faultCount = faultCount;
    }

    public void incrementRequestCount(long value) {
        this.requestCount += value;
    }

    public void incrementErrorCount(long value) {
        this.errorCount += value;
    }

    public void incrementFaultCount(long value) {
        this.faultCount += value;
    }

    public void addErrorExemplar(Exemplar exemplar) {
        this.errorExemplars.add(exemplar);
    }

    public void addFaultExemplar(Exemplar exemplar) {
        this.faultExemplars.add(exemplar);
    }

    public void addLatencyDuration(Double latency) {
        this.latencyDurations.add(latency);
    }

    public long getRequestCount() {
        return this.requestCount;
    }

    public long getErrorCount() {
        return this.errorCount;
    }

    public long getFaultCount() {
        return this.faultCount;
    }

    public List<Exemplar> getErrorExemplars() {
        return this.errorExemplars;
    }

    public List<Exemplar> getFaultExemplars() {
        return this.faultExemplars;
    }

    public List<Double> getLatencyDurations() {
        return this.latencyDurations;
    }
}

