/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.otel_apm_service_map.model.internal;

import java.util.HashMap;
import java.util.Map;
import org.opensearch.dataprepper.plugins.processor.otel_apm_service_map.model.internal.ClientSpanDecoration;
import org.opensearch.dataprepper.plugins.processor.otel_apm_service_map.model.internal.ServerSpanDecoration;

public class EphemeralSpanDecorations {
    private final Map<String, ClientSpanDecoration> clientDecorations = new HashMap<String, ClientSpanDecoration>();
    private final Map<String, ServerSpanDecoration> serverDecorations = new HashMap<String, ServerSpanDecoration>();

    public void setClientDecoration(String spanIdHex, ClientSpanDecoration decoration) {
        this.clientDecorations.put(spanIdHex, decoration);
    }

    public ClientSpanDecoration getClientDecoration(String spanIdHex) {
        return this.clientDecorations.get(spanIdHex);
    }

    public void setServerDecoration(String spanIdHex, ServerSpanDecoration decoration) {
        this.serverDecorations.put(spanIdHex, decoration);
    }

    public ServerSpanDecoration getServerDecoration(String spanIdHex) {
        return this.serverDecorations.get(spanIdHex);
    }

    public boolean hasClientDecoration(String spanIdHex) {
        return this.clientDecorations.containsKey(spanIdHex);
    }

    public boolean hasServerDecoration(String spanIdHex) {
        return this.serverDecorations.containsKey(spanIdHex);
    }

    public void clear() {
        this.clientDecorations.clear();
        this.serverDecorations.clear();
    }

    public int size() {
        return this.clientDecorations.size() + this.serverDecorations.size();
    }
}

