/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.otel_apm_service_map.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import org.opensearch.dataprepper.plugins.processor.otel_apm_service_map.model.Node;
import org.opensearch.dataprepper.plugins.processor.otel_apm_service_map.model.Operation;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class NodeOperationDetail {
    @JsonProperty(value="sourceNode")
    private final Node sourceNode;
    @JsonProperty(value="targetNode")
    private final Node targetNode;
    @JsonProperty(value="sourceOperation")
    private final Operation sourceOperation;
    @JsonProperty(value="targetOperation")
    private final Operation targetOperation;
    @JsonProperty(value="nodeConnectionHash")
    private final String nodeConnectionHash;
    @JsonProperty(value="operationConnectionHash")
    private final String operationConnectionHash;
    @JsonProperty(value="timestamp")
    private final String timestamp;

    public NodeOperationDetail(Node sourceNode, Node targetNode, Operation sourceOperation, Operation targetOperation, Instant timestamp) {
        this.sourceNode = sourceNode;
        this.targetNode = targetNode;
        this.sourceOperation = sourceOperation;
        this.targetOperation = targetOperation;
        this.timestamp = DateTimeFormatter.ISO_INSTANT.format(timestamp);
        this.nodeConnectionHash = String.valueOf(Objects.hash(sourceNode, targetNode));
        if (sourceOperation != null && sourceOperation.getName() != null) {
            String targetOpName = targetOperation != null ? targetOperation.getName() : null;
            this.operationConnectionHash = String.valueOf(Objects.hash(sourceNode, targetNode, sourceOperation.getName(), targetOpName));
        } else {
            this.operationConnectionHash = null;
        }
    }

    public Node getSourceNode() {
        return this.sourceNode;
    }

    public Node getTargetNode() {
        return this.targetNode;
    }

    public Operation getSourceOperation() {
        return this.sourceOperation;
    }

    public Operation getTargetOperation() {
        return this.targetOperation;
    }

    public String getNodeConnectionHash() {
        return this.nodeConnectionHash;
    }

    public String getOperationConnectionHash() {
        return this.operationConnectionHash;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeOperationDetail that = (NodeOperationDetail)o;
        return Objects.equals(this.sourceNode, that.sourceNode) && Objects.equals(this.targetNode, that.targetNode) && Objects.equals(this.sourceOperation, that.sourceOperation) && Objects.equals(this.targetOperation, that.targetOperation) && Objects.equals(this.nodeConnectionHash, that.nodeConnectionHash) && Objects.equals(this.operationConnectionHash, that.operationConnectionHash) && Objects.equals(this.timestamp, that.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.sourceNode, this.targetNode, this.sourceOperation, this.targetOperation, this.nodeConnectionHash, this.operationConnectionHash, this.timestamp);
    }

    public String toString() {
        return "NodeOperationDetail{sourceNode=" + String.valueOf(this.sourceNode) + ", targetNode=" + String.valueOf(this.targetNode) + ", sourceOperation=" + String.valueOf(this.sourceOperation) + ", targetOperation=" + String.valueOf(this.targetOperation) + ", nodeConnectionHash='" + this.nodeConnectionHash + "', operationConnectionHash='" + this.operationConnectionHash + "', timestamp='" + this.timestamp + "'}";
    }
}

