/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.oteltrace.http;

import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.Consumes;
import com.linecorp.armeria.server.annotation.Post;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Timer;
import io.opentelemetry.proto.collector.trace.v1.ExportTraceServiceRequest;
import io.opentelemetry.proto.collector.trace.v1.ExportTraceServiceResponse;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.exceptions.BadRequestException;
import org.opensearch.dataprepper.exceptions.BufferWriteException;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.otel.codec.OTelProtoCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArmeriaHttpService {
    private static final Logger LOG = LoggerFactory.getLogger(ArmeriaHttpService.class);
    public static final String REQUEST_TIMEOUTS = "requestTimeouts";
    public static final String REQUESTS_RECEIVED = "requestsReceived";
    public static final String BAD_REQUESTS = "badRequests";
    public static final String REQUESTS_TOO_LARGE = "requestsTooLarge";
    public static final String INTERNAL_SERVER_ERROR = "internalServerError";
    public static final String SUCCESS_REQUESTS = "successRequests";
    public static final String PAYLOAD_SIZE = "payloadSize";
    public static final String REQUEST_PROCESS_DURATION = "requestProcessDuration";
    private final OTelProtoCodec.OTelProtoDecoder oTelProtoDecoder;
    private final Buffer<Record<Object>> buffer;
    private final int bufferWriteTimeoutInMillis;
    private final Counter requestsReceivedCounter;
    private final Counter successRequestsCounter;
    private final DistributionSummary payloadSizeSummary;
    private final Timer requestProcessDuration;

    public ArmeriaHttpService(Buffer<Record<Object>> buffer, OTelProtoCodec.OTelProtoDecoder otelProtoDecoder, PluginMetrics pluginMetrics, int bufferWriteTimeoutInMillis) {
        this.buffer = buffer;
        this.oTelProtoDecoder = otelProtoDecoder;
        this.bufferWriteTimeoutInMillis = bufferWriteTimeoutInMillis;
        this.requestsReceivedCounter = pluginMetrics.counter(REQUESTS_RECEIVED);
        this.successRequestsCounter = pluginMetrics.counter(SUCCESS_REQUESTS);
        this.payloadSizeSummary = pluginMetrics.summary(PAYLOAD_SIZE);
        this.requestProcessDuration = pluginMetrics.timer(REQUEST_PROCESS_DURATION);
    }

    @Post(value="/opentelemetry.proto.collector.trace.v1.TraceService/Export")
    @Consumes(value="application/json")
    public ExportTraceServiceResponse exportTrace(ExportTraceServiceRequest request) {
        this.requestsReceivedCounter.increment();
        this.payloadSizeSummary.record((double)request.getSerializedSize());
        this.requestProcessDuration.record(() -> this.processRequest(request));
        return ExportTraceServiceResponse.newBuilder().build();
    }

    private void processRequest(ExportTraceServiceRequest request) {
        List spans;
        try {
            spans = this.oTelProtoDecoder.parseExportTraceServiceRequest(request, Instant.now());
        }
        catch (Exception e) {
            LOG.warn(DataPrepperMarkers.SENSITIVE, "Failed to parse request with error '{}'. Request body: {}.", (Object)e.getMessage(), (Object)request);
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
        try {
            if (this.buffer.isByteBuffer()) {
                Map requestsMap = this.oTelProtoDecoder.splitExportTraceServiceRequestByTraceId(request);
                for (Map.Entry entry : requestsMap.entrySet()) {
                    this.buffer.writeBytes(((ExportTraceServiceRequest)entry.getValue()).toByteArray(), (String)entry.getKey(), this.bufferWriteTimeoutInMillis);
                }
            } else {
                List records = spans.stream().map(span -> new Record(span)).collect(Collectors.toList());
                this.buffer.writeAll(records, this.bufferWriteTimeoutInMillis);
            }
        }
        catch (Exception e) {
            if (ServiceRequestContext.current().isTimedOut()) {
                LOG.warn("Exception writing to buffer but request already timed out.", (Throwable)e);
                return;
            }
            LOG.error("Failed to write the request of size {} due to:", (Object)request.toString().length(), (Object)e);
            throw new BufferWriteException(e.getMessage(), (Throwable)e);
        }
        if (ServiceRequestContext.current().isTimedOut()) {
            LOG.warn("Buffer write completed successfully but request already timed out.");
            return;
        }
        this.successRequestsCounter.increment();
    }
}

