/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.aws.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.regions.Region;

public class AwsCredentialsOptions {
    private static final AwsCredentialsOptions DEFAULT_OPTIONS = new AwsCredentialsOptions();
    private static final AwsCredentialsOptions DEFAULT_OPTIONS_WITH_DEFAULT_CREDS_PROVIDER = AwsCredentialsOptions.builder().withUseDefaultCredentialsProvider(true).build();
    private final String stsRoleArn;
    private final String stsExternalId;
    private final Region region;
    private final Map<String, String> stsHeaderOverrides;
    private final boolean useDefaultCredentialsProvider;

    private AwsCredentialsOptions(Builder builder) {
        this.stsRoleArn = builder.stsRoleArn;
        this.stsExternalId = builder.stsExternalId;
        this.region = builder.region;
        this.stsHeaderOverrides = builder.stsHeaderOverrides != null ? new HashMap<String, String>(builder.stsHeaderOverrides) : Collections.emptyMap();
        this.useDefaultCredentialsProvider = builder.useDefaultCredentialsProvider;
    }

    private AwsCredentialsOptions() {
        this.stsRoleArn = null;
        this.stsExternalId = null;
        this.region = null;
        this.stsHeaderOverrides = Collections.emptyMap();
        this.useDefaultCredentialsProvider = false;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static AwsCredentialsOptions defaultOptions() {
        return DEFAULT_OPTIONS;
    }

    public static AwsCredentialsOptions defaultOptionsWithDefaultCredentialsProvider() {
        return DEFAULT_OPTIONS_WITH_DEFAULT_CREDS_PROVIDER;
    }

    public String getStsRoleArn() {
        return this.stsRoleArn;
    }

    public String getStsExternalId() {
        return this.stsExternalId;
    }

    public Region getRegion() {
        return this.region;
    }

    public Map<String, String> getStsHeaderOverrides() {
        return this.stsHeaderOverrides;
    }

    public boolean isUseDefaultCredentialsProvider() {
        return this.useDefaultCredentialsProvider;
    }

    public static class Builder {
        private String stsRoleArn;
        private String stsExternalId;
        private Region region;
        private Map<String, String> stsHeaderOverrides = Collections.emptyMap();
        private boolean useDefaultCredentialsProvider = false;

        public Builder withStsRoleArn(String stsRoleArn) {
            this.stsRoleArn = stsRoleArn;
            return this;
        }

        public Builder withStsExternalId(String stsExternalId) {
            this.stsExternalId = stsExternalId;
            return this;
        }

        public Builder withRegion(Region region) {
            this.region = region;
            return this;
        }

        public Builder withRegion(String region) {
            this.region = Region.of((String)region);
            return this;
        }

        public Builder withStsHeaderOverrides(Map<String, String> stsHeaderOverrides) {
            this.stsHeaderOverrides = stsHeaderOverrides;
            return this;
        }

        public Builder withUseDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            this.useDefaultCredentialsProvider = useDefaultCredentialsProvider;
            return this;
        }

        public AwsCredentialsOptions build() {
            return new AwsCredentialsOptions(this);
        }
    }
}

