/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.common.sink;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.TimeUnit;
import org.opensearch.dataprepper.common.sink.SinkMetrics;
import org.opensearch.dataprepper.metrics.PluginMetrics;

public class DefaultSinkMetrics
implements SinkMetrics {
    static final String DEFAULT_EVENT_NAME = "Event";
    static final String SINK_REQUESTS_SUCCEEDED = "sinkRequestsSucceeded";
    static final String SINK_REQUESTS_FAILED = "sinkRequestsFailed";
    static final String SINK_REQUEST_LATENCY = "sinkRequestLatency";
    static final String SINK_RETRIES = "sinkRetries";
    static final String SINK_REQUEST_SIZE = "sinkRequestSize";
    private final Counter sinkRequestsSucceeded;
    private final Counter sinkRequestsFailed;
    private final Counter sinkEventsSucceeded;
    private final Counter sinkEventsFailed;
    private final Counter sinkEventsDropped;
    private final Counter sinkRetries;
    private final Timer sinkRequestLatency;
    private final DistributionSummary sinkRequestSize;
    private final DistributionSummary sinkEventSize;

    public DefaultSinkMetrics(PluginMetrics pluginMetrics, String eventName) {
        this.sinkRequestsSucceeded = pluginMetrics.counter(SINK_REQUESTS_SUCCEEDED);
        this.sinkEventsSucceeded = pluginMetrics.counter("sink" + eventName + "sSucceeded");
        this.sinkRequestsFailed = pluginMetrics.counter(SINK_REQUESTS_FAILED);
        this.sinkEventsFailed = pluginMetrics.counter("sink" + eventName + "sFailed");
        this.sinkEventsDropped = pluginMetrics.counter("sink" + eventName + "sDropped");
        this.sinkRetries = pluginMetrics.counter(SINK_RETRIES);
        this.sinkRequestLatency = pluginMetrics.timer(SINK_REQUEST_LATENCY);
        this.sinkRequestSize = pluginMetrics.summary(SINK_REQUEST_SIZE);
        this.sinkEventSize = pluginMetrics.summary("sink" + eventName + "Size");
    }

    public DefaultSinkMetrics(PluginMetrics pluginMetrics) {
        this(pluginMetrics, DEFAULT_EVENT_NAME);
    }

    @Override
    public void incrementEventsSuccessCounter(int value) {
        this.sinkEventsSucceeded.increment((double)value);
    }

    @Override
    public void incrementRequestsSuccessCounter(int value) {
        this.sinkRequestsSucceeded.increment((double)value);
    }

    @Override
    public void incrementEventsFailedCounter(int value) {
        this.sinkEventsFailed.increment((double)value);
    }

    @Override
    public void incrementEventsDroppedCounter(int value) {
        this.sinkEventsDropped.increment((double)value);
    }

    @Override
    public void incrementRequestsFailedCounter(int value) {
        this.sinkRequestsFailed.increment((double)value);
    }

    @Override
    public void incrementRetries(int value) {
        this.sinkRetries.increment((double)value);
    }

    @Override
    public void recordRequestLatency(long amount, TimeUnit unit) {
        this.sinkRequestLatency.record(amount, unit);
    }

    @Override
    public void recordRequestLatency(double value) {
        this.recordRequestLatency((long)value, TimeUnit.NANOSECONDS);
    }

    @Override
    public void recordRequestSize(double value) {
        this.sinkRequestSize.record(value);
    }

    public void recordEventSize(double value) {
        this.sinkEventSize.record(value);
    }
}

