/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.rss;

import com.apptasticsoftware.rssreader.RssReader;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.document.Document;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.source.Source;
import org.opensearch.dataprepper.plugins.source.rss.RSSSourceConfig;
import org.opensearch.dataprepper.plugins.source.rss.RssReaderTask;

@DataPrepperPlugin(name="rss", pluginType=Source.class, pluginConfigurationType=RSSSourceConfig.class)
public class RSSSource
implements Source<Record<Document>> {
    private final PluginMetrics pluginMetrics;
    private final RSSSourceConfig rssSourceConfig;
    private RssReaderTask rssReaderTask;
    private final RssReader rssReader = new RssReader();
    private final ScheduledExecutorService scheduledExecutorService;

    @DataPrepperPluginConstructor
    public RSSSource(PluginMetrics pluginMetrics, RSSSourceConfig rssSourceConfig) {
        this.pluginMetrics = pluginMetrics;
        this.rssSourceConfig = rssSourceConfig;
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
    }

    public void start(Buffer<Record<Document>> buffer) {
        if (buffer == null) {
            throw new IllegalStateException("Buffer is null");
        }
        this.rssReaderTask = new RssReaderTask(this.rssReader, this.rssSourceConfig.getUrl(), buffer);
        this.scheduledExecutorService.scheduleAtFixedRate(this.rssReaderTask, 0L, this.rssSourceConfig.getPollingFrequency().toMillis(), TimeUnit.MILLISECONDS);
    }

    public void stop() {
        this.scheduledExecutorService.shutdown();
    }
}

