/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.ClientRequestContextWrapper;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.RequestContextStorage;
import com.linecorp.armeria.common.RequestContextWrapper;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.Sampler;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.ServiceRequestContextWrapper;
import java.util.Objects;

final class LeakTracingRequestContextStorage
implements RequestContextStorage {
    private final RequestContextStorage delegate;
    private final Sampler<? super RequestContext> sampler;

    LeakTracingRequestContextStorage(RequestContextStorage delegate, Sampler<? super RequestContext> sampler) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.sampler = Objects.requireNonNull(sampler, "sampler");
    }

    @Override
    @Nullable
    public <T extends RequestContext> T push(RequestContext toPush) {
        Objects.requireNonNull(toPush, "toPush");
        if (this.sampler.isSampled(toPush)) {
            return this.delegate.push(LeakTracingRequestContextStorage.wrapRequestContext(LeakTracingRequestContextStorage.unwrapTraceableRequestContext(toPush)));
        }
        return this.delegate.push(toPush);
    }

    private static RequestContext unwrapTraceableRequestContext(RequestContext ctx) {
        RequestContext unwrapped;
        while ((unwrapped = ctx.unwrap()) instanceof TraceableRequestContext) {
            ctx = unwrapped;
        }
        return unwrapped;
    }

    @Override
    public void pop(RequestContext current, @Nullable RequestContext toRestore) {
        Objects.requireNonNull(current, "current");
        this.delegate.pop(current, toRestore);
    }

    @Override
    @Nullable
    public <T extends RequestContext> T currentOrNull() {
        return this.delegate.currentOrNull();
    }

    @Override
    public RequestContextStorage unwrap() {
        return this.delegate;
    }

    private static RequestContextWrapper<?> wrapRequestContext(RequestContext ctx) {
        if (ctx instanceof ClientRequestContext) {
            return new TraceableClientRequestContext((ClientRequestContext)ctx);
        }
        assert (ctx instanceof ServiceRequestContext);
        return new TraceableServiceRequestContext((ServiceRequestContext)ctx);
    }

    private static String stacktraceToString(StackTraceElement[] stackTrace, RequestContext unwrap) {
        StringBuilder builder = new StringBuilder(512);
        builder.append(unwrap).append(System.lineSeparator());
        for (int i = 1; i < stackTrace.length; ++i) {
            builder.append("\tat ").append(stackTrace[i]).append(System.lineSeparator());
        }
        return builder.toString();
    }

    private static interface TraceableRequestContext {
    }

    private static final class TraceableClientRequestContext
    extends ClientRequestContextWrapper
    implements TraceableRequestContext {
        private final StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();

        private TraceableClientRequestContext(ClientRequestContext delegate) {
            super(delegate);
        }

        @Override
        public String toString() {
            return LeakTracingRequestContextStorage.stacktraceToString(this.stackTrace, (RequestContext)this.unwrap());
        }
    }

    private static final class TraceableServiceRequestContext
    extends ServiceRequestContextWrapper
    implements TraceableRequestContext {
        private final StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();

        private TraceableServiceRequestContext(ServiceRequestContext delegate) {
            super(delegate);
        }

        @Override
        public String toString() {
            return LeakTracingRequestContextStorage.stacktraceToString(this.stackTrace, (RequestContext)this.unwrap());
        }
    }
}

