/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.cloudwatch_logs.client;

import com.linecorp.armeria.client.retry.Backoff;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.model.event.EventHandle;
import org.opensearch.dataprepper.model.failures.DlqObject;
import org.opensearch.dataprepper.plugins.dlq.DlqPushHandler;
import org.opensearch.dataprepper.plugins.sink.cloudwatch_logs.client.CloudWatchLogsMetrics;
import org.opensearch.dataprepper.plugins.sink.cloudwatch_logs.utils.CloudWatchLogsSinkUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClient;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsException;
import software.amazon.awssdk.services.cloudwatchlogs.model.InputLogEvent;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutLogEventsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutLogEventsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.RejectedLogEventsInfo;

public class CloudWatchLogsDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(CloudWatchLogsDispatcher.class);
    private CloudWatchLogsClient cloudWatchLogsClient;
    private CloudWatchLogsMetrics cloudWatchLogsMetrics;
    private DlqPushHandler dlqPushHandler;
    private boolean dropIfDlqNotConfigured;
    private Executor executor;
    private String logGroup;
    private String logStream;
    private int retryCount;

    public CloudWatchLogsDispatcher(CloudWatchLogsClient cloudWatchLogsClient, CloudWatchLogsMetrics cloudWatchLogsMetrics, DlqPushHandler dlqPushHandler, boolean dropIfDlqNotConfigured, Executor executor, String logGroup, String logStream, int retryCount) {
        this.cloudWatchLogsClient = cloudWatchLogsClient;
        this.cloudWatchLogsMetrics = cloudWatchLogsMetrics;
        this.logGroup = logGroup;
        this.logStream = logStream;
        this.retryCount = retryCount;
        this.dlqPushHandler = dlqPushHandler;
        this.dropIfDlqNotConfigured = dropIfDlqNotConfigured;
        this.executor = executor;
    }

    public List<InputLogEvent> prepareInputLogEvents(Collection<byte[]> eventMessageBytes) {
        ArrayList<InputLogEvent> logEventList = new ArrayList<InputLogEvent>();
        for (byte[] data : eventMessageBytes) {
            InputLogEvent tempLogEvent = (InputLogEvent)InputLogEvent.builder().message(new String(data, StandardCharsets.UTF_8)).timestamp(Long.valueOf(System.currentTimeMillis())).build();
            logEventList.add(tempLogEvent);
        }
        return logEventList;
    }

    public void dispatchLogs(List<InputLogEvent> inputLogEvents, List<EventHandle> eventHandles) {
        PutLogEventsRequest putLogEventsRequest = (PutLogEventsRequest)PutLogEventsRequest.builder().logEvents(inputLogEvents).logGroupName(this.logGroup).logStreamName(this.logStream).build();
        this.executor.execute(Uploader.builder().cloudWatchLogsClient(this.cloudWatchLogsClient).cloudWatchLogsMetrics(this.cloudWatchLogsMetrics).dlqPushHandler(this.dlqPushHandler).putLogEventsRequest(putLogEventsRequest).eventHandles(eventHandles).dropIfDlqNotConfigured(this.dropIfDlqNotConfigured).totalEventCount(inputLogEvents.size()).retryCount(this.retryCount).build());
    }

    public static CloudWatchLogsDispatcherBuilder builder() {
        return new CloudWatchLogsDispatcherBuilder();
    }

    public static class CloudWatchLogsDispatcherBuilder {
        private CloudWatchLogsClient cloudWatchLogsClient;
        private CloudWatchLogsMetrics cloudWatchLogsMetrics;
        private DlqPushHandler dlqPushHandler;
        private boolean dropIfDlqNotConfigured;
        private Executor executor;
        private String logGroup;
        private String logStream;
        private int retryCount;

        CloudWatchLogsDispatcherBuilder() {
        }

        public CloudWatchLogsDispatcherBuilder cloudWatchLogsClient(CloudWatchLogsClient cloudWatchLogsClient) {
            this.cloudWatchLogsClient = cloudWatchLogsClient;
            return this;
        }

        public CloudWatchLogsDispatcherBuilder cloudWatchLogsMetrics(CloudWatchLogsMetrics cloudWatchLogsMetrics) {
            this.cloudWatchLogsMetrics = cloudWatchLogsMetrics;
            return this;
        }

        public CloudWatchLogsDispatcherBuilder dlqPushHandler(DlqPushHandler dlqPushHandler) {
            this.dlqPushHandler = dlqPushHandler;
            return this;
        }

        public CloudWatchLogsDispatcherBuilder dropIfDlqNotConfigured(boolean dropIfDlqNotConfigured) {
            this.dropIfDlqNotConfigured = dropIfDlqNotConfigured;
            return this;
        }

        public CloudWatchLogsDispatcherBuilder executor(Executor executor) {
            this.executor = executor;
            return this;
        }

        public CloudWatchLogsDispatcherBuilder logGroup(String logGroup) {
            this.logGroup = logGroup;
            return this;
        }

        public CloudWatchLogsDispatcherBuilder logStream(String logStream) {
            this.logStream = logStream;
            return this;
        }

        public CloudWatchLogsDispatcherBuilder retryCount(int retryCount) {
            this.retryCount = retryCount;
            return this;
        }

        public CloudWatchLogsDispatcher build() {
            return new CloudWatchLogsDispatcher(this.cloudWatchLogsClient, this.cloudWatchLogsMetrics, this.dlqPushHandler, this.dropIfDlqNotConfigured, this.executor, this.logGroup, this.logStream, this.retryCount);
        }

        public String toString() {
            return "CloudWatchLogsDispatcher.CloudWatchLogsDispatcherBuilder(cloudWatchLogsClient=" + String.valueOf(this.cloudWatchLogsClient) + ", cloudWatchLogsMetrics=" + String.valueOf(this.cloudWatchLogsMetrics) + ", dlqPushHandler=" + String.valueOf(this.dlqPushHandler) + ", dropIfDlqNotConfigured=" + this.dropIfDlqNotConfigured + ", executor=" + String.valueOf(this.executor) + ", logGroup=" + this.logGroup + ", logStream=" + this.logStream + ", retryCount=" + this.retryCount + ")";
        }
    }

    protected static class Uploader
    implements Runnable {
        static final long INITIAL_DELAY_MS = 50L;
        static final int MULTIPLE_FAILURES_METRIC_COUNT = 5;
        static final long MAXIMUM_DELAY_MS = Duration.ofMinutes(10L).toMillis();
        private final CloudWatchLogsClient cloudWatchLogsClient;
        private final CloudWatchLogsMetrics cloudWatchLogsMetrics;
        private DlqPushHandler dlqPushHandler;
        private final PutLogEventsRequest putLogEventsRequest;
        private final List<EventHandle> eventHandles;
        private final int totalEventCount;
        private final int retryCount;
        private boolean dropIfDlqNotConfigured;

        @Override
        public void run() {
            this.upload();
        }

        public void upload() {
            boolean failedToTransmit = true;
            int failCount = 0;
            String failureMessage = "";
            PutLogEventsResponse putLogEventsResponse = null;
            List<Object> dlqObjects = new ArrayList();
            Backoff backoff = Backoff.exponential((long)50L, (long)MAXIMUM_DELAY_MS).withMaxAttempts(this.retryCount);
            try {
                while (failedToTransmit && failCount < this.retryCount) {
                    try {
                        putLogEventsResponse = this.cloudWatchLogsClient.putLogEvents(this.putLogEventsRequest);
                        this.cloudWatchLogsMetrics.increaseRequestSuccessCounter(1);
                        failedToTransmit = false;
                    }
                    catch (SdkClientException | CloudWatchLogsException e) {
                        long delayMillis;
                        failureMessage = e.getMessage();
                        LOG.error(DataPrepperMarkers.NOISY, "Failed to push logs with error: {}", (Object)e.getMessage());
                        this.cloudWatchLogsMetrics.increaseRequestFailCounter(1);
                        if (++failCount % 5 == 0) {
                            this.cloudWatchLogsMetrics.increaseRequestMultiFailCounter(1);
                        }
                        if ((delayMillis = backoff.nextDelayMillis(failCount)) <= 0L) continue;
                        Thread.sleep(delayMillis);
                    }
                }
            }
            catch (Exception e) {
                failureMessage = e.getMessage();
                LOG.warn(DataPrepperMarkers.NOISY, "Uploader Thread got interrupted during retransmission with exception: {}", (Object)e.getMessage());
                Thread.currentThread().interrupt();
            }
            if (failedToTransmit) {
                this.cloudWatchLogsMetrics.increaseLogEventFailCounter(this.totalEventCount);
                List logEvents = this.putLogEventsRequest.logEvents();
                for (int i = 0; i < logEvents.size(); ++i) {
                    DlqObject dlqObject = CloudWatchLogsSinkUtils.createDlqObject(0, this.eventHandles.get(i), ((InputLogEvent)logEvents.get(i)).message(), failureMessage, this.dlqPushHandler, this.dropIfDlqNotConfigured);
                    if (dlqObject == null) continue;
                    dlqObjects.add(dlqObject);
                }
            } else {
                if (putLogEventsResponse != null) {
                    dlqObjects = this.getDlqObjectsFromResponse(putLogEventsResponse);
                }
                this.cloudWatchLogsMetrics.increaseLogEventSuccessCounter(this.totalEventCount - dlqObjects.size());
                this.releaseEventHandles(putLogEventsResponse);
            }
            CloudWatchLogsSinkUtils.handleDlqObjects(dlqObjects, this.dlqPushHandler);
        }

        List<DlqObject> getDlqObjectsFromResponse(PutLogEventsResponse putLogEventsResponse) {
            ArrayList<DlqObject> dlqObjects = new ArrayList<DlqObject>();
            RejectedLogEventsInfo rejectedLogEventsInfo = putLogEventsResponse.rejectedLogEventsInfo();
            List logEvents = this.putLogEventsRequest.logEvents();
            ArrayList failedLogEvents = new ArrayList();
            if (rejectedLogEventsInfo != null) {
                Integer startIndex;
                Integer endIndex = rejectedLogEventsInfo.tooOldLogEventEndIndex();
                if (endIndex != null) {
                    int i = 0;
                    for (InputLogEvent logEvent : logEvents.subList(0, endIndex)) {
                        DlqObject dlqObject = CloudWatchLogsSinkUtils.createDlqObject(0, this.eventHandles.get(i), logEvent.message(), "Too old log event", this.dlqPushHandler, this.dropIfDlqNotConfigured);
                        if (dlqObject != null) {
                            dlqObjects.add(dlqObject);
                        }
                        ++i;
                    }
                }
                if ((startIndex = rejectedLogEventsInfo.tooNewLogEventStartIndex()) != null) {
                    int i = 0;
                    for (InputLogEvent logEvent : logEvents.subList(startIndex, logEvents.size())) {
                        DlqObject dlqObject = CloudWatchLogsSinkUtils.createDlqObject(0, this.eventHandles.get(startIndex + i), logEvent.message(), "Too old log event", this.dlqPushHandler, this.dropIfDlqNotConfigured);
                        if (dlqObject != null) {
                            dlqObjects.add(dlqObject);
                        }
                        ++i;
                    }
                }
            }
            return dlqObjects;
        }

        private void releaseEventHandles(PutLogEventsResponse putLogEventsResponse) {
            if (putLogEventsResponse == null || putLogEventsResponse.rejectedLogEventsInfo() == null) {
                this.eventHandles.forEach(eventHandle -> eventHandle.release(true));
                return;
            }
            Integer tooOldEndIndex = putLogEventsResponse.rejectedLogEventsInfo().tooOldLogEventEndIndex();
            Integer tooNewStartIndex = putLogEventsResponse.rejectedLogEventsInfo().tooNewLogEventStartIndex();
            for (int i = 0; i < this.eventHandles.size(); ++i) {
                boolean isRejected;
                boolean bl = isRejected = tooOldEndIndex != null && i < tooOldEndIndex || tooNewStartIndex != null && i >= tooNewStartIndex;
                if (isRejected) continue;
                this.eventHandles.get(i).release(true);
            }
        }

        Uploader(CloudWatchLogsClient cloudWatchLogsClient, CloudWatchLogsMetrics cloudWatchLogsMetrics, DlqPushHandler dlqPushHandler, PutLogEventsRequest putLogEventsRequest, List<EventHandle> eventHandles, int totalEventCount, int retryCount, boolean dropIfDlqNotConfigured) {
            this.cloudWatchLogsClient = cloudWatchLogsClient;
            this.cloudWatchLogsMetrics = cloudWatchLogsMetrics;
            this.dlqPushHandler = dlqPushHandler;
            this.putLogEventsRequest = putLogEventsRequest;
            this.eventHandles = eventHandles;
            this.totalEventCount = totalEventCount;
            this.retryCount = retryCount;
            this.dropIfDlqNotConfigured = dropIfDlqNotConfigured;
        }

        public static UploaderBuilder builder() {
            return new UploaderBuilder();
        }

        public static class UploaderBuilder {
            private CloudWatchLogsClient cloudWatchLogsClient;
            private CloudWatchLogsMetrics cloudWatchLogsMetrics;
            private DlqPushHandler dlqPushHandler;
            private PutLogEventsRequest putLogEventsRequest;
            private List<EventHandle> eventHandles;
            private int totalEventCount;
            private int retryCount;
            private boolean dropIfDlqNotConfigured;

            UploaderBuilder() {
            }

            public UploaderBuilder cloudWatchLogsClient(CloudWatchLogsClient cloudWatchLogsClient) {
                this.cloudWatchLogsClient = cloudWatchLogsClient;
                return this;
            }

            public UploaderBuilder cloudWatchLogsMetrics(CloudWatchLogsMetrics cloudWatchLogsMetrics) {
                this.cloudWatchLogsMetrics = cloudWatchLogsMetrics;
                return this;
            }

            public UploaderBuilder dlqPushHandler(DlqPushHandler dlqPushHandler) {
                this.dlqPushHandler = dlqPushHandler;
                return this;
            }

            public UploaderBuilder putLogEventsRequest(PutLogEventsRequest putLogEventsRequest) {
                this.putLogEventsRequest = putLogEventsRequest;
                return this;
            }

            public UploaderBuilder eventHandles(List<EventHandle> eventHandles) {
                this.eventHandles = eventHandles;
                return this;
            }

            public UploaderBuilder totalEventCount(int totalEventCount) {
                this.totalEventCount = totalEventCount;
                return this;
            }

            public UploaderBuilder retryCount(int retryCount) {
                this.retryCount = retryCount;
                return this;
            }

            public UploaderBuilder dropIfDlqNotConfigured(boolean dropIfDlqNotConfigured) {
                this.dropIfDlqNotConfigured = dropIfDlqNotConfigured;
                return this;
            }

            public Uploader build() {
                return new Uploader(this.cloudWatchLogsClient, this.cloudWatchLogsMetrics, this.dlqPushHandler, this.putLogEventsRequest, this.eventHandles, this.totalEventCount, this.retryCount, this.dropIfDlqNotConfigured);
            }

            public String toString() {
                return "CloudWatchLogsDispatcher.Uploader.UploaderBuilder(cloudWatchLogsClient=" + String.valueOf(this.cloudWatchLogsClient) + ", cloudWatchLogsMetrics=" + String.valueOf(this.cloudWatchLogsMetrics) + ", dlqPushHandler=" + String.valueOf(this.dlqPushHandler) + ", putLogEventsRequest=" + String.valueOf(this.putLogEventsRequest) + ", eventHandles=" + String.valueOf(this.eventHandles) + ", totalEventCount=" + this.totalEventCount + ", retryCount=" + this.retryCount + ", dropIfDlqNotConfigured=" + this.dropIfDlqNotConfigured + ")";
            }
        }
    }
}

