/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.cloudwatch_logs.buffer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opensearch.dataprepper.model.event.EventHandle;
import org.opensearch.dataprepper.plugins.sink.cloudwatch_logs.buffer.Buffer;

public class InMemoryBuffer
implements Buffer {
    private List<byte[]> eventsBuffered = new ArrayList<byte[]>();
    private int bufferSize = 0;
    private List<EventHandle> eventHandles = new ArrayList<EventHandle>();

    InMemoryBuffer() {
    }

    @Override
    public int getEventCount() {
        return this.eventsBuffered.size();
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public List<EventHandle> getEventHandles() {
        return Collections.unmodifiableList(this.eventHandles);
    }

    @Override
    public void writeEvent(EventHandle eventHandle, byte[] event) {
        this.eventHandles.add(eventHandle);
        this.eventsBuffered.add(event);
        this.bufferSize += event.length;
    }

    @Override
    public byte[] popEvent() {
        if (this.eventsBuffered.isEmpty()) {
            return new byte[0];
        }
        this.bufferSize -= this.eventsBuffered.get(0).length;
        return this.eventsBuffered.remove(0);
    }

    @Override
    public List<byte[]> getBufferedData() {
        return Collections.unmodifiableList(this.eventsBuffered);
    }

    @Override
    public void clearBuffer() {
        this.bufferSize = 0;
        this.eventsBuffered.clear();
    }

    @Override
    public void resetBuffer() {
        this.bufferSize = 0;
        this.eventsBuffered = new ArrayList<byte[]>();
        this.eventHandles = new ArrayList<EventHandle>();
    }
}

