/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.s3.configuration;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.time.Duration;
import org.hibernate.validator.constraints.time.DurationMax;
import org.hibernate.validator.constraints.time.DurationMin;

public class ClientOptions {
    private static final int DEFAULT_MAX_CONNECTIONS = 50;
    private static final Duration DEFAULT_ACQUIRE_TIMEOUT = Duration.ofSeconds(10L);
    @JsonProperty(value="max_connections")
    @Min(value=1L)
    @Max(value=5000L)
    private @Min(value=1L) @Max(value=5000L) int maxConnections = 50;
    @JsonProperty(value="acquire_timeout")
    @DurationMin(seconds=1L)
    @DurationMax(seconds=3600L)
    private @DurationMin(seconds=1L) @DurationMax(seconds=3600L) Duration acquireTimeout = DEFAULT_ACQUIRE_TIMEOUT;

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public Duration getAcquireTimeout() {
        return this.acquireTimeout;
    }
}

