/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.s3;

import java.util.HashMap;
import java.util.Map;
import org.opensearch.dataprepper.plugins.sink.s3.ObjectMetadataConfig;
import org.opensearch.dataprepper.plugins.sink.s3.PredefinedObjectMetadata;

public class ObjectMetadata {
    private Map<String, String> metadata;
    private ObjectMetadataConfig objectMetadataConfig;
    private PredefinedObjectMetadata predefinedObjectMetadata;

    public ObjectMetadata(Object objectMetadataConfig) {
        if (objectMetadataConfig instanceof ObjectMetadataConfig) {
            this.objectMetadataConfig = (ObjectMetadataConfig)objectMetadataConfig;
        } else {
            this.predefinedObjectMetadata = (PredefinedObjectMetadata)objectMetadataConfig;
        }
        this.metadata = new HashMap<String, String>();
    }

    public void setEventCount(int eventCount) {
        String numberOfEventsKey = null;
        if (this.objectMetadataConfig != null) {
            numberOfEventsKey = this.objectMetadataConfig.getNumberOfEventsKey();
        } else if (this.predefinedObjectMetadata != null) {
            numberOfEventsKey = this.predefinedObjectMetadata.getNumberOfObjects();
        }
        if (numberOfEventsKey != null) {
            this.metadata.put(numberOfEventsKey, Integer.toString(eventCount));
        }
    }

    public Map<String, String> get() {
        return this.metadata;
    }
}

