/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.s3;

import org.opensearch.dataprepper.aws.api.AwsCredentialsOptions;
import org.opensearch.dataprepper.aws.api.AwsCredentialsSupplier;
import org.opensearch.dataprepper.plugins.sink.s3.S3SinkConfig;
import org.opensearch.dataprepper.plugins.sink.s3.configuration.AwsAuthenticationOptions;
import org.opensearch.dataprepper.plugins.sink.s3.configuration.ClientOptions;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;

public final class ClientFactory {
    private ClientFactory() {
    }

    static S3AsyncClient createS3AsyncClient(S3SinkConfig s3SinkConfig, AwsCredentialsSupplier awsCredentialsSupplier) {
        AwsCredentialsOptions awsCredentialsOptions = ClientFactory.convertToCredentialsOptions(s3SinkConfig.getAwsAuthenticationOptions());
        AwsCredentialsProvider awsCredentialsProvider = awsCredentialsSupplier.getProvider(awsCredentialsOptions);
        S3AsyncClientBuilder s3AsyncClientBuilder = (S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)S3AsyncClient.builder().region(s3SinkConfig.getAwsAuthenticationOptions().getAwsRegion())).crossRegionAccessEnabled(Boolean.valueOf(true))).credentialsProvider(awsCredentialsProvider)).overrideConfiguration(ClientFactory.createOverrideConfiguration(s3SinkConfig));
        if (s3SinkConfig.getClientOptions() != null) {
            ClientOptions clientOptions = s3SinkConfig.getClientOptions();
            SdkAsyncHttpClient httpClient = NettyNioAsyncHttpClient.builder().connectionAcquisitionTimeout(clientOptions.getAcquireTimeout()).maxConcurrency(Integer.valueOf(clientOptions.getMaxConnections())).build();
            s3AsyncClientBuilder.httpClient(httpClient);
        }
        return (S3AsyncClient)s3AsyncClientBuilder.build();
    }

    private static ClientOverrideConfiguration createOverrideConfiguration(S3SinkConfig s3SinkConfig) {
        RetryPolicy retryPolicy = RetryPolicy.builder().numRetries(Integer.valueOf(s3SinkConfig.getMaxConnectionRetries() * s3SinkConfig.getMaxUploadRetries())).build();
        return (ClientOverrideConfiguration)ClientOverrideConfiguration.builder().retryPolicy(retryPolicy).build();
    }

    private static AwsCredentialsOptions convertToCredentialsOptions(AwsAuthenticationOptions awsAuthenticationOptions) {
        return AwsCredentialsOptions.builder().withRegion(awsAuthenticationOptions.getAwsRegion()).withStsRoleArn(awsAuthenticationOptions.getAwsStsRoleArn()).withStsExternalId(awsAuthenticationOptions.getAwsStsExternalId()).withStsHeaderOverrides(awsAuthenticationOptions.getAwsStsHeaderOverrides()).build();
    }
}

