/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Objects;

public class ServiceMapRelationship {
    private static final String MD5 = "MD5";
    private static final ThreadLocal<MessageDigest> THREAD_LOCAL_MESSAGE_DIGEST = new ThreadLocal();
    private String serviceName;
    private String kind;
    private Endpoint destination;
    private Endpoint target;
    private String traceGroupName;
    private String hashId;

    private ServiceMapRelationship() {
    }

    private ServiceMapRelationship(String serviceName, String kind, Endpoint destination, Endpoint target, String traceGroupName) {
        this.serviceName = serviceName;
        this.kind = kind;
        this.destination = destination;
        this.target = target;
        this.traceGroupName = traceGroupName;
        this.hashId = this.md5Hash();
    }

    public static ServiceMapRelationship newDestinationRelationship(String serviceName, String spanKind, String domain, String resource, String traceGroupName) {
        return new ServiceMapRelationship(serviceName, spanKind, new Endpoint(resource, domain), null, traceGroupName);
    }

    public static ServiceMapRelationship newTargetRelationship(String serviceName, String spanKind, String domain, String resource, String traceGroupName) {
        return new ServiceMapRelationship(serviceName, spanKind, null, new Endpoint(resource, domain), traceGroupName);
    }

    public static ServiceMapRelationship newIsolatedService(String serviceName, String traceGroupName) {
        return new ServiceMapRelationship(serviceName, null, null, null, traceGroupName);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getKind() {
        return this.kind;
    }

    public Endpoint getDestination() {
        return this.destination;
    }

    public Endpoint getTarget() {
        return this.target;
    }

    public String getTraceGroupName() {
        return this.traceGroupName;
    }

    public String getHashId() {
        return this.hashId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceMapRelationship that = (ServiceMapRelationship)o;
        return Objects.equals(this.serviceName, that.serviceName) && Objects.equals(this.kind, that.kind) && Objects.equals(this.destination, that.destination) && Objects.equals(this.target, that.target) && Objects.equals(this.traceGroupName, that.traceGroupName);
    }

    public int hashCode() {
        return Objects.hash(this.serviceName, this.kind, this.destination, this.target, this.traceGroupName);
    }

    private String unhashedString() {
        String result = this.serviceName + "," + this.kind + "," + this.traceGroupName + ",";
        if (this.target != null) {
            result = result + this.target.resource + "," + this.target.domain;
        }
        result = result + ",";
        if (this.destination != null) {
            result = result + this.destination.resource + "," + this.destination.domain;
        }
        return result;
    }

    private String md5Hash() {
        if (THREAD_LOCAL_MESSAGE_DIGEST.get() == null) {
            try {
                THREAD_LOCAL_MESSAGE_DIGEST.set(MessageDigest.getInstance(MD5));
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        THREAD_LOCAL_MESSAGE_DIGEST.get().reset();
        THREAD_LOCAL_MESSAGE_DIGEST.get().update(this.unhashedString().getBytes());
        return Base64.getEncoder().encodeToString(THREAD_LOCAL_MESSAGE_DIGEST.get().digest());
    }

    public static class Endpoint {
        private final String resource;
        private final String domain;

        @JsonCreator
        public Endpoint(@JsonProperty(value="resource") String resource, @JsonProperty(value="domain") String domain) {
            this.resource = resource;
            this.domain = domain;
        }

        public String getResource() {
            return this.resource;
        }

        public String getDomain() {
            return this.domain;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Endpoint endpoint = (Endpoint)o;
            return Objects.equals(this.resource, endpoint.resource) && Objects.equals(this.domain, endpoint.domain);
        }

        public int hashCode() {
            return Objects.hash(this.resource, this.domain);
        }
    }
}

