/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.s3.common.source;

import java.util.Objects;
import java.util.Optional;

public class S3ObjectReference {
    private final String bucketName;
    private final String key;
    private final String owner;

    private S3ObjectReference(String bucketName, String key, String owner) {
        this.bucketName = bucketName;
        this.key = key;
        this.owner = owner;
    }

    public static Builder bucketAndKey(String bucketName, String key) {
        Objects.requireNonNull(bucketName, "bucketName must be non null");
        Objects.requireNonNull(key, "key must be non null");
        return new Builder(bucketName, key);
    }

    Optional<String> getBucketOwner() {
        return Optional.ofNullable(this.owner);
    }

    public String toString() {
        return "[bucketName=" + this.bucketName + ", key=" + this.key + "]";
    }

    public String uri() {
        return String.format("s3://%s/%s", this.bucketName, this.key);
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getKey() {
        return this.key;
    }

    public static final class Builder {
        private final String bucketName;
        private final String key;
        private String owner;

        private Builder(String bucketName, String key) {
            this.bucketName = bucketName;
            this.key = key;
        }

        public Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public S3ObjectReference build() {
            return new S3ObjectReference(this.bucketName, this.key, this.owner);
        }
    }
}

