/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.translate;

import java.util.concurrent.ConcurrentHashMap;
import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventKey;
import org.opensearch.dataprepper.model.event.EventKeyFactory;
import org.opensearch.dataprepper.plugins.processor.translate.KeyInfo;
import org.opensearch.dataprepper.plugins.processor.translate.KeyResolver;

class CachingKeyResolver
implements KeyResolver {
    private final ConcurrentHashMap<String, KeyInfo> keyInfoCache;
    private final EventKeyFactory eventKeyFactory;

    CachingKeyResolver(EventKeyFactory eventKeyFactory) {
        this.eventKeyFactory = eventKeyFactory;
        this.keyInfoCache = new ConcurrentHashMap();
    }

    @Override
    public EventKey resolveKey(String keyStr, Event event, ExpressionEvaluator evaluator) {
        if (keyStr == null) {
            return null;
        }
        KeyInfo keyInfo = this.keyInfoCache.computeIfAbsent(keyStr, k -> new KeyInfo((String)k, this.eventKeyFactory));
        return keyInfo.resolveKey(event, evaluator);
    }

    int getCacheSize() {
        return this.keyInfoCache.size();
    }

    void clearCache() {
        this.keyInfoCache.clear();
    }
}

