/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.s3.configuration;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import java.time.Duration;
import org.hibernate.validator.constraints.time.DurationMax;
import org.hibernate.validator.constraints.time.DurationMin;

public class SqsOptions {
    private static final int DEFAULT_MAXIMUM_MESSAGES = 10;
    private static final Boolean DEFAULT_VISIBILITY_DUPLICATE_PROTECTION = false;
    private static final Duration DEFAULT_VISIBILITY_TIMEOUT_SECONDS = Duration.ofSeconds(30L);
    private static final Duration DEFAULT_VISIBILITY_DUPLICATE_PROTECTION_TIMEOUT = Duration.ofHours(2L);
    private static final Duration DEFAULT_WAIT_TIME_SECONDS = Duration.ofSeconds(20L);
    private static final Duration DEFAULT_POLL_DELAY_SECONDS = Duration.ofSeconds(0L);
    private static final Duration DEFAULT_SHUTDOWN_TIMEOUT = Duration.ofSeconds(30L);
    @JsonProperty(value="queue_url")
    @NotBlank(message="SQS URL cannot be null or empty")
    private @NotBlank(message="SQS URL cannot be null or empty") String sqsUrl;
    @JsonProperty(value="maximum_messages")
    @Min(value=1L)
    @Max(value=10L)
    private @Min(value=1L) @Max(value=10L) int maximumMessages = 10;
    @JsonProperty(value="visibility_timeout")
    @DurationMin(seconds=0L)
    @DurationMax(seconds=43200L)
    private @DurationMin(seconds=0L) @DurationMax(seconds=43200L) Duration visibilityTimeout = DEFAULT_VISIBILITY_TIMEOUT_SECONDS;
    @JsonProperty(value="visibility_duplication_protection")
    private Boolean visibilityDuplicateProtection = DEFAULT_VISIBILITY_DUPLICATE_PROTECTION;
    @JsonProperty(value="visibility_duplicate_protection_timeout")
    @DurationMin(seconds=30L)
    @DurationMax(hours=24L)
    private @DurationMin(seconds=30L) @DurationMax(hours=24L) Duration visibilityDuplicateProtectionTimeout = DEFAULT_VISIBILITY_DUPLICATE_PROTECTION_TIMEOUT;
    @JsonProperty(value="wait_time")
    @DurationMin(seconds=0L)
    @DurationMax(seconds=20L)
    private @DurationMin(seconds=0L) @DurationMax(seconds=20L) Duration waitTime = DEFAULT_WAIT_TIME_SECONDS;
    @JsonProperty(value="poll_delay")
    @DurationMin(seconds=0L)
    private @DurationMin(seconds=0L) Duration pollDelay = DEFAULT_POLL_DELAY_SECONDS;
    @JsonPropertyDescription(value="Messages that contain an ApproximateReceiveCount greater than this value will be deleted")
    @JsonProperty(value="max_receive_attempts")
    @Min(value=1L)
    private @Min(value=1L) Integer maxReceiveAttempts;
    @JsonProperty(value="shutdown_timeout")
    @DurationMin(seconds=30L)
    private @DurationMin(seconds=30L) Duration shutdownTimeout = DEFAULT_SHUTDOWN_TIMEOUT;

    public String getSqsUrl() {
        return this.sqsUrl;
    }

    public int getMaximumMessages() {
        return this.maximumMessages;
    }

    public Duration getVisibilityTimeout() {
        return this.visibilityTimeout;
    }

    public Duration getVisibilityDuplicateProtectionTimeout() {
        return this.visibilityDuplicateProtectionTimeout;
    }

    public Boolean getVisibilityDuplicateProtection() {
        return this.visibilityDuplicateProtection;
    }

    public Duration getWaitTime() {
        return this.waitTime;
    }

    public Duration getPollDelay() {
        return this.pollDelay;
    }

    public Integer getMaxReceiveAttempts() {
        return this.maxReceiveAttempts;
    }

    public Duration getShutdownTimeout() {
        return this.shutdownTimeout;
    }
}

