/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.s3;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.opensearch.dataprepper.common.concurrent.BackgroundThreadFactory;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSetManager;
import org.opensearch.dataprepper.model.source.coordinator.SourceCoordinator;
import org.opensearch.dataprepper.plugins.s3.common.ownership.BucketOwnerProvider;
import org.opensearch.dataprepper.plugins.source.s3.S3ClientBuilderFactory;
import org.opensearch.dataprepper.plugins.source.s3.S3ObjectDeleteWorker;
import org.opensearch.dataprepper.plugins.source.s3.S3ObjectHandler;
import org.opensearch.dataprepper.plugins.source.s3.S3SourceConfig;
import org.opensearch.dataprepper.plugins.source.s3.S3SourceProgressState;
import org.opensearch.dataprepper.plugins.source.s3.ScanObjectWorker;
import org.opensearch.dataprepper.plugins.source.s3.ScanOptions;
import org.opensearch.dataprepper.plugins.source.s3.configuration.S3ScanBucketOptions;

public class S3ScanService {
    static final long SHUTDOWN_TIMEOUT = 30L;
    private final S3SourceConfig s3SourceConfig;
    private final List<S3ScanBucketOptions> s3ScanBucketOptions;
    private final S3ClientBuilderFactory s3ClientBuilderFactory;
    private final LocalDateTime endDateTime;
    private final LocalDateTime startDateTime;
    private final Duration range;
    private final S3ObjectHandler s3ObjectHandler;
    private Thread scanObjectWorkerThread;
    private final BucketOwnerProvider bucketOwnerProvider;
    private final SourceCoordinator<S3SourceProgressState> sourceCoordinator;
    private final AcknowledgementSetManager acknowledgementSetManager;
    private final S3ObjectDeleteWorker s3ObjectDeleteWorker;
    private final PluginMetrics pluginMetrics;
    private final ExecutorService executorService;
    private final List<ScanObjectWorker> workers;

    public S3ScanService(S3SourceConfig s3SourceConfig, S3ClientBuilderFactory s3ClientBuilderFactory, S3ObjectHandler s3ObjectHandler, BucketOwnerProvider bucketOwnerProvider, SourceCoordinator<S3SourceProgressState> sourceCoordinator, AcknowledgementSetManager acknowledgementSetManager, S3ObjectDeleteWorker s3ObjectDeleteWorker, PluginMetrics pluginMetrics) {
        this.s3SourceConfig = s3SourceConfig;
        this.s3ScanBucketOptions = s3SourceConfig.getS3ScanScanOptions().getBuckets();
        this.s3ClientBuilderFactory = s3ClientBuilderFactory;
        this.endDateTime = s3SourceConfig.getS3ScanScanOptions().getEndTime();
        this.startDateTime = s3SourceConfig.getS3ScanScanOptions().getStartTime();
        this.range = s3SourceConfig.getS3ScanScanOptions().getRange();
        this.s3ObjectHandler = s3ObjectHandler;
        this.bucketOwnerProvider = bucketOwnerProvider;
        this.sourceCoordinator = sourceCoordinator;
        this.acknowledgementSetManager = acknowledgementSetManager;
        this.s3ObjectDeleteWorker = s3ObjectDeleteWorker;
        this.pluginMetrics = pluginMetrics;
        this.workers = new ArrayList<ScanObjectWorker>();
        this.executorService = Executors.newFixedThreadPool(s3SourceConfig.getNumWorkers(), (ThreadFactory)BackgroundThreadFactory.defaultExecutorThreadFactory((String)"s3-source-scan"));
    }

    public void start() {
        long backOffMs = this.s3SourceConfig.getBackOff().toMillis();
        for (int i = 0; i < this.s3SourceConfig.getNumWorkers(); ++i) {
            ScanObjectWorker scanObjectWorker = new ScanObjectWorker(this.s3ClientBuilderFactory.getS3Client(), this.getScanOptions(), this.s3ObjectHandler, this.bucketOwnerProvider, this.sourceCoordinator, this.s3SourceConfig, this.acknowledgementSetManager, this.s3ObjectDeleteWorker, backOffMs, this.pluginMetrics);
            this.workers.add(scanObjectWorker);
            this.executorService.submit(new Thread(scanObjectWorker));
        }
    }

    public void stop() {
        block4: {
            for (int i = 0; i < this.s3SourceConfig.getNumWorkers(); ++i) {
                this.workers.get(i).stop();
            }
            this.executorService.shutdown();
            try {
                if (!this.executorService.awaitTermination(30L, TimeUnit.SECONDS)) {
                    this.executorService.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                if (!(e.getCause() instanceof InterruptedException)) break block4;
                this.executorService.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    List<ScanOptions> getScanOptions() {
        ArrayList<ScanOptions> scanOptionsList = new ArrayList<ScanOptions>();
        this.s3ScanBucketOptions.forEach(obj -> this.buildScanOptions((List<ScanOptions>)scanOptionsList, (S3ScanBucketOptions)obj));
        return scanOptionsList;
    }

    private void buildScanOptions(List<ScanOptions> scanOptionsList, S3ScanBucketOptions scanBucketOptions) {
        scanOptionsList.add(ScanOptions.builder().setStartDateTime(this.startDateTime).setEndDateTime(this.endDateTime).setRange(this.range).setBucketOption(scanBucketOptions.getS3ScanBucketOption()).build());
    }
}

