/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.s3;

import org.opensearch.dataprepper.aws.api.AwsCredentialsOptions;
import org.opensearch.dataprepper.aws.api.AwsCredentialsSupplier;
import org.opensearch.dataprepper.plugins.s3.common.config.AwsAuthenticationOptions;
import org.opensearch.dataprepper.plugins.source.s3.S3SourceConfig;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

class AwsAuthenticationAdapter {
    private final AwsCredentialsSupplier awsCredentialsSupplier;
    private final S3SourceConfig s3SourceConfig;

    AwsAuthenticationAdapter(AwsCredentialsSupplier awsCredentialsSupplier, S3SourceConfig s3SourceConfig) {
        this.awsCredentialsSupplier = awsCredentialsSupplier;
        this.s3SourceConfig = s3SourceConfig;
    }

    AwsCredentialsProvider getCredentialsProvider() {
        AwsAuthenticationOptions awsAuthenticationOptions = this.s3SourceConfig.getAwsAuthenticationOptions();
        AwsCredentialsOptions options = AwsCredentialsOptions.builder().withStsRoleArn(awsAuthenticationOptions.getAwsStsRoleArn()).withRegion(awsAuthenticationOptions.getAwsRegion()).withStsHeaderOverrides(awsAuthenticationOptions.getAwsStsHeaderOverrides()).withStsExternalId(awsAuthenticationOptions.getAwsStsExternalId()).build();
        return this.awsCredentialsSupplier.getProvider(options);
    }
}

