/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kinesis.source;

import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.plugins.kinesis.source.apihandler.KinesisClientApiHandler;
import org.opensearch.dataprepper.plugins.kinesis.source.configuration.ConsumerStrategy;
import org.opensearch.dataprepper.plugins.kinesis.source.configuration.KinesisSourceConfig;
import org.opensearch.dataprepper.plugins.kinesis.source.configuration.KinesisStreamConfig;
import software.amazon.kinesis.common.InitialPositionInStream;
import software.amazon.kinesis.common.InitialPositionInStreamExtended;
import software.amazon.kinesis.common.StreamConfig;
import software.amazon.kinesis.common.StreamIdentifier;
import software.amazon.kinesis.processor.FormerStreamsLeasesDeletionStrategy;
import software.amazon.kinesis.processor.MultiStreamTracker;

public class KinesisMultiStreamTracker
implements MultiStreamTracker {
    private final KinesisSourceConfig sourceConfig;
    private final String applicationName;
    private final KinesisClientApiHandler kinesisClientAPIHandler;

    public KinesisMultiStreamTracker(KinesisSourceConfig sourceConfig, String applicationName, KinesisClientApiHandler kinesisClientAPIHandler) {
        this.sourceConfig = sourceConfig;
        this.applicationName = applicationName;
        this.kinesisClientAPIHandler = kinesisClientAPIHandler;
    }

    public List<StreamConfig> streamConfigList() {
        return this.sourceConfig.getStreams().stream().map(this::createStreamConfig).collect(Collectors.toList());
    }

    private StreamConfig createStreamConfig(KinesisStreamConfig kinesisStreamConfig) {
        StreamIdentifier streamIdentifier = this.getStreamIdentifier(kinesisStreamConfig);
        InitialPositionInStreamExtended initialPosition = this.getInitialPositionExtended(kinesisStreamConfig);
        if (this.sourceConfig.getConsumerStrategy() == ConsumerStrategy.POLLING) {
            return new StreamConfig(streamIdentifier, initialPosition);
        }
        if (Objects.nonNull(kinesisStreamConfig.getStreamArn()) && Objects.nonNull(kinesisStreamConfig.getConsumerArn())) {
            return new StreamConfig(streamIdentifier, initialPosition, kinesisStreamConfig.getConsumerArn());
        }
        if (Objects.nonNull(kinesisStreamConfig.getStreamArn())) {
            String consumerArn = this.kinesisClientAPIHandler.getConsumerArnForStream(kinesisStreamConfig.getStreamArn(), this.applicationName);
            return new StreamConfig(streamIdentifier, initialPosition, consumerArn);
        }
        return new StreamConfig(streamIdentifier, initialPosition);
    }

    private StreamIdentifier getStreamIdentifier(KinesisStreamConfig kinesisStreamConfig) {
        String streamArn = kinesisStreamConfig.getStreamArn();
        String streamName = kinesisStreamConfig.getName();
        if (Objects.isNull(streamArn) && Objects.isNull(streamName)) {
            throw new IllegalArgumentException("Either ARN or name must be specified for Kinesis stream configuration");
        }
        return this.kinesisClientAPIHandler.getStreamIdentifier(streamArn != null ? streamArn : streamName);
    }

    private InitialPositionInStreamExtended getInitialPositionExtended(KinesisStreamConfig kinesisStreamConfig) {
        if (kinesisStreamConfig.getInitialPosition() == InitialPositionInStream.AT_TIMESTAMP) {
            Instant timestamp;
            if (Objects.nonNull(kinesisStreamConfig.getInitialTimestamp())) {
                timestamp = kinesisStreamConfig.getInitialTimestamp().atOffset(ZoneOffset.UTC).toInstant();
            } else if (Objects.nonNull(kinesisStreamConfig.getRange())) {
                timestamp = Instant.now().minus(kinesisStreamConfig.getRange());
            } else {
                throw new IllegalArgumentException("Either initial_timestamp or range must be specified when using AT_TIMESTAMP initial_position");
            }
            return InitialPositionInStreamExtended.newInitialPositionAtTimestamp((Date)Date.from(timestamp));
        }
        return InitialPositionInStreamExtended.newInitialPosition((InitialPositionInStream)kinesisStreamConfig.getInitialPosition());
    }

    public FormerStreamsLeasesDeletionStrategy formerStreamsLeasesDeletionStrategy() {
        return new FormerStreamsLeasesDeletionStrategy.AutoDetectionAndDeferredDeletionStrategy(){

            public Duration waitPeriodToDeleteFormerStreams() {
                return Duration.ofSeconds(10L);
            }
        };
    }
}

