/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.DescribeEntityRequest;
import software.amazon.awssdk.services.glue.model.DescribeEntityResponse;
import software.amazon.awssdk.services.glue.model.Field;

public class DescribeEntityIterable
implements SdkIterable<DescribeEntityResponse> {
    private final GlueClient client;
    private final DescribeEntityRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeEntityIterable(GlueClient client, DescribeEntityRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeEntityResponseFetcher();
    }

    public Iterator<DescribeEntityResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Field> fields() {
        Function<DescribeEntityResponse, Iterator> getIterator = response -> {
            if (response != null && response.fields() != null) {
                return response.fields().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeEntityResponseFetcher
    implements SyncPageFetcher<DescribeEntityResponse> {
        private DescribeEntityResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEntityResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeEntityResponse nextPage(DescribeEntityResponse previousPage) {
            if (previousPage == null) {
                return DescribeEntityIterable.this.client.describeEntity(DescribeEntityIterable.this.firstRequest);
            }
            return DescribeEntityIterable.this.client.describeEntity((DescribeEntityRequest)((Object)DescribeEntityIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

