/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.rds.export;

import java.util.UUID;
import org.opensearch.dataprepper.plugins.source.rds.leader.RdsApiStrategy;
import org.opensearch.dataprepper.plugins.source.rds.model.SnapshotInfo;

public class SnapshotManager {
    private final RdsApiStrategy snapshotStrategy;

    public SnapshotManager(RdsApiStrategy snapshotStrategy) {
        this.snapshotStrategy = snapshotStrategy;
    }

    public SnapshotInfo createSnapshot(String dbIdentifier) {
        String snapshotId = this.generateSnapshotId(dbIdentifier);
        return this.snapshotStrategy.createSnapshot(dbIdentifier, snapshotId);
    }

    public SnapshotInfo checkSnapshotStatus(String snapshotId) {
        return this.snapshotStrategy.describeSnapshot(snapshotId);
    }

    private String generateSnapshotId(String dbIdentifier) {
        return dbIdentifier + "-snapshot-" + UUID.randomUUID().toString().substring(0, 8);
    }
}

