/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.rds.datatype.mysql.handler;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import org.opensearch.dataprepper.plugins.source.rds.datatype.mysql.MySQLDataType;
import org.opensearch.dataprepper.plugins.source.rds.datatype.mysql.MySQLDataTypeHandler;
import org.opensearch.dataprepper.plugins.source.rds.model.TableMetadata;

public class TemporalTypeHandler
implements MySQLDataTypeHandler {
    private static final String MYSQL_DATE_FORMAT = "yyyy-MM-dd";
    private static final String MYSQL_TIME_FORMAT = "HH:mm:ss[.SSSSSS]";
    private static final String MYSQL_DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss[.SSSSSS]";
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss[.SSSSSS]");
    private static final DateTimeFormatter DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss[.SSSSSS]");

    @Override
    public Long handle(MySQLDataType columnType, String columnName, Object value, TableMetadata metadata) {
        if (value == null) {
            return null;
        }
        String strValue = value.toString().trim();
        try {
            switch (columnType) {
                case DATE: {
                    return this.handleDate(strValue);
                }
                case TIME: {
                    return this.handleTime(strValue);
                }
                case DATETIME: 
                case TIMESTAMP: {
                    return this.handleDateTime(strValue);
                }
                case YEAR: {
                    return this.handleYear(strValue);
                }
            }
            throw new IllegalArgumentException("Unsupported temporal data type: " + String.valueOf((Object)columnType));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Failed to parse %s value: %s", new Object[]{columnType, strValue}), e);
        }
    }

    private Long handleTime(String timeStr) {
        try {
            Long timeEpoch = this.parseDateTimeStrAsEpochMillis(timeStr);
            if (timeEpoch != null) {
                return timeEpoch;
            }
            LocalTime time = LocalTime.parse(timeStr, TIME_FORMATTER);
            return time.atDate(LocalDate.EPOCH).toInstant(ZoneOffset.UTC).toEpochMilli();
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException("Invalid time format: " + timeStr, e);
        }
    }

    private Long handleDate(String dateStr) {
        try {
            if ("0000-00-00".equals(dateStr)) {
                return null;
            }
            Long dateEpoch = this.parseDateTimeStrAsEpochMillis(dateStr);
            if (dateEpoch != null) {
                return dateEpoch;
            }
            LocalDate date = LocalDate.parse(dateStr, DATE_FORMATTER);
            return date.atStartOfDay(ZoneOffset.UTC).toInstant().toEpochMilli();
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException("Invalid date format: " + dateStr, e);
        }
    }

    private Long handleDateTime(String dateTimeStr) {
        try {
            Long dateTimeEpoch = this.parseDateTimeStrAsEpochMillis(dateTimeStr);
            if (dateTimeEpoch != null) {
                return dateTimeEpoch;
            }
            return LocalDateTime.parse(dateTimeStr, DATETIME_FORMATTER).toInstant(ZoneOffset.UTC).toEpochMilli();
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException("Invalid datetime format: " + dateTimeStr, e);
        }
    }

    private Long parseDateTimeStrAsEpochMillis(String dateTimeStr) {
        try {
            if (dateTimeStr.length() > 13) {
                return Long.parseLong(dateTimeStr) / 1000L;
            }
            return Long.parseLong(dateTimeStr);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private Long handleYear(String yearStr) {
        try {
            long year = Long.parseLong(yearStr);
            if (year <= 1900L || year > 2155L) {
                return 0L;
            }
            return year;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid year format: " + yearStr, e);
        }
    }
}

