/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.opensearch.worker;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch.cat.IndicesResponse;
import co.elastic.clients.elasticsearch.cat.indices.IndicesRecord;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.OpenSearchException;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.model.plugin.PluginComponentRefresher;
import org.opensearch.dataprepper.model.source.coordinator.PartitionIdentifier;
import org.opensearch.dataprepper.plugins.source.opensearch.OpenSearchSourceConfiguration;
import org.opensearch.dataprepper.plugins.source.opensearch.configuration.IndexParametersConfiguration;
import org.opensearch.dataprepper.plugins.source.opensearch.configuration.OpenSearchIndex;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.client.ClusterClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSearchIndexPartitionCreationSupplier
implements Function<Map<String, Object>, List<PartitionIdentifier>> {
    private static final Logger LOG = LoggerFactory.getLogger(OpenSearchIndexPartitionCreationSupplier.class);
    private final OpenSearchSourceConfiguration openSearchSourceConfiguration;
    private final IndexParametersConfiguration indexParametersConfiguration;
    private PluginComponentRefresher<OpenSearchClient, OpenSearchSourceConfiguration> openSearchClientRefresher;
    private PluginComponentRefresher<ElasticsearchClient, OpenSearchSourceConfiguration> elasticsearchClientRefresher;

    public OpenSearchIndexPartitionCreationSupplier(OpenSearchSourceConfiguration openSearchSourceConfiguration, ClusterClientFactory clusterClientFactory) {
        this.openSearchSourceConfiguration = openSearchSourceConfiguration;
        this.indexParametersConfiguration = openSearchSourceConfiguration.getIndexParametersConfiguration();
        PluginComponentRefresher clientRefresher = clusterClientFactory.getClientRefresher();
        if (OpenSearchClient.class.isAssignableFrom(clientRefresher.getComponentClass())) {
            this.openSearchClientRefresher = clientRefresher;
        } else if (ElasticsearchClient.class.isAssignableFrom(clientRefresher.getComponentClass())) {
            this.elasticsearchClientRefresher = clientRefresher;
        } else {
            throw new IllegalArgumentException(String.format("ClusterClientFactory provided an invalid client object to the index partition creation supplier. The clientRefresher must be of type OpenSearchClientRefresher. The clientRefresher passed is of class %s", clientRefresher.getClass()));
        }
    }

    @Override
    public List<PartitionIdentifier> apply(Map<String, Object> globalStateMap) {
        if (Objects.nonNull(this.openSearchClientRefresher)) {
            return this.applyForOpenSearchClient(globalStateMap);
        }
        if (Objects.nonNull(this.elasticsearchClientRefresher)) {
            return this.applyForElasticSearchClient(globalStateMap);
        }
        return Collections.emptyList();
    }

    private List<PartitionIdentifier> applyForOpenSearchClient(Map<String, Object> globalStateMap) {
        org.opensearch.client.opensearch.cat.IndicesResponse indicesResponse;
        try {
            indicesResponse = ((OpenSearchClient)this.openSearchClientRefresher.get()).cat().indices();
        }
        catch (IOException | OpenSearchException e) {
            LOG.error("There was an exception when calling /_cat/indices to create new index partitions", e);
            return Collections.emptyList();
        }
        LOG.debug("Found {} indices", (Object)indicesResponse.valueBody().size());
        ArrayList<PartitionIdentifier> partitions = new ArrayList<PartitionIdentifier>();
        int matchCount = 0;
        for (org.opensearch.client.opensearch.cat.indices.IndicesRecord esIndicesRecord : indicesResponse.valueBody()) {
            if (!this.shouldIndexBeProcessed(esIndicesRecord.index())) continue;
            partitions.add(PartitionIdentifier.builder().withPartitionKey(esIndicesRecord.index()).build());
            ++matchCount;
        }
        if (matchCount == 0) {
            LOG.warn(DataPrepperMarkers.NOISY, "No indices matched the configured regex patterns after applying include/exclude filters");
        }
        return partitions;
    }

    private List<PartitionIdentifier> applyForElasticSearchClient(Map<String, Object> globalStateMap) {
        IndicesResponse indicesResponse;
        try {
            indicesResponse = ((ElasticsearchClient)this.elasticsearchClientRefresher.get()).cat().indices();
        }
        catch (ElasticsearchException | IOException e) {
            LOG.error("There was an exception when calling /_cat/indices to create new index partitions", e);
            return Collections.emptyList();
        }
        LOG.debug("Found {} indices", (Object)indicesResponse.valueBody().size());
        ArrayList<PartitionIdentifier> partitions = new ArrayList<PartitionIdentifier>();
        int matchCount = 0;
        for (IndicesRecord esIndicesRecord : indicesResponse.valueBody()) {
            if (!this.shouldIndexBeProcessed(esIndicesRecord.index())) continue;
            partitions.add(PartitionIdentifier.builder().withPartitionKey(esIndicesRecord.index()).build());
            ++matchCount;
        }
        if (matchCount == 0) {
            LOG.warn(DataPrepperMarkers.NOISY, "No indices matched the configured regex patterns after applying include/exclude filters");
        }
        return partitions;
    }

    private boolean shouldIndexBeProcessed(String indexName) {
        if (Objects.isNull(indexName)) {
            return false;
        }
        if (Objects.isNull(this.indexParametersConfiguration)) {
            return true;
        }
        List<OpenSearchIndex> includedIndices = this.indexParametersConfiguration.getIncludedIndices();
        List<OpenSearchIndex> excludedIndices = this.indexParametersConfiguration.getExcludedIndices();
        boolean matchesIncludedPattern = Objects.isNull(includedIndices) || includedIndices.isEmpty() || this.doesIndexMatchPattern(includedIndices, indexName);
        boolean matchesExcludePattern = this.doesIndexMatchPattern(excludedIndices, indexName);
        return matchesIncludedPattern && !matchesExcludePattern;
    }

    private boolean doesIndexMatchPattern(List<OpenSearchIndex> indices, String indexName) {
        for (OpenSearchIndex index : indices) {
            Matcher matcher = index.getIndexNamePattern().matcher(indexName);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }
}

