/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.opensearch.configuration;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.Size;
import java.util.Map;
import org.opensearch.dataprepper.plugins.sink.opensearch.configuration.ServerlessOptions;
import software.amazon.awssdk.regions.Region;

public class AwsAuthenticationConfiguration {
    @JsonProperty(value="region")
    @Size(min=1, message="Region cannot be empty string")
    private @Size(min=1, message="Region cannot be empty string") String awsRegion = "us-east-1";
    @JsonProperty(value="sts_role_arn")
    @Size(min=20, max=2048, message="awsStsRoleArn length should be between 1 and 2048 characters")
    private @Size(min=20, max=2048, message="awsStsRoleArn length should be between 1 and 2048 characters") String awsStsRoleArn;
    @JsonProperty(value="sts_external_id")
    @Size(min=2, max=1224, message="awsStsExternalId length should be between 2 and 1224 characters")
    private @Size(min=2, max=1224, message="awsStsExternalId length should be between 2 and 1224 characters") String awsStsExternalId;
    @JsonProperty(value="sts_header_overrides")
    @Size(max=5, message="sts_header_overrides supports a maximum of 5 headers to override")
    private @Size(max=5, message="sts_header_overrides supports a maximum of 5 headers to override") Map<String, String> awsStsHeaderOverrides;
    @JsonProperty(value="serverless")
    private boolean serverless = false;
    @JsonProperty(value="serverless_options")
    private ServerlessOptions serverlessOptions;

    public String getAwsStsRoleArn() {
        return this.awsStsRoleArn;
    }

    public String getAwsStsExternalId() {
        return this.awsStsExternalId;
    }

    public Region getAwsRegion() {
        return this.awsRegion != null ? Region.of((String)this.awsRegion) : null;
    }

    public Map<String, String> getAwsStsHeaderOverrides() {
        return this.awsStsHeaderOverrides;
    }

    public boolean isServerlessCollection() {
        return this.serverless;
    }

    public ServerlessOptions getServerlessOptions() {
        return this.serverlessOptions;
    }
}

