/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.common.opensearch;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.services.opensearchserverless.OpenSearchServerlessClient;
import software.amazon.awssdk.services.opensearchserverless.model.CreateSecurityPolicyRequest;
import software.amazon.awssdk.services.opensearchserverless.model.GetSecurityPolicyRequest;
import software.amazon.awssdk.services.opensearchserverless.model.GetSecurityPolicyResponse;
import software.amazon.awssdk.services.opensearchserverless.model.ResourceNotFoundException;
import software.amazon.awssdk.services.opensearchserverless.model.SecurityPolicyDetail;
import software.amazon.awssdk.services.opensearchserverless.model.SecurityPolicyType;
import software.amazon.awssdk.services.opensearchserverless.model.UpdateSecurityPolicyRequest;

public class ServerlessNetworkPolicyUpdater {
    static final String COLLECTION = "collection";
    static final String CREATED_BY_DATA_PREPPER = "Created by Data Prepper";
    static final String DESCRIPTION = "Description";
    static final String RESOURCE = "Resource";
    static final String RESOURCE_TYPE = "ResourceType";
    static final String RULES = "Rules";
    static final String SOURCE_VPCES = "SourceVPCEs";
    private static final Logger LOG = LoggerFactory.getLogger(ServerlessNetworkPolicyUpdater.class);
    private final OpenSearchServerlessClient client;

    public ServerlessNetworkPolicyUpdater(OpenSearchServerlessClient client) {
        this.client = client;
    }

    public void updateNetworkPolicy(String networkPolicyName, String collectionName, String vpceId) {
        try {
            Document newStatement = ServerlessNetworkPolicyUpdater.createNetworkPolicyStatement(collectionName, vpceId);
            Optional<SecurityPolicyDetail> maybeNetworkPolicy = this.getNetworkPolicy(networkPolicyName);
            if (maybeNetworkPolicy.isPresent()) {
                Document existingPolicy = maybeNetworkPolicy.get().policy();
                String policyVersion = maybeNetworkPolicy.get().policyVersion();
                List existingStatements = existingPolicy.asList();
                if (ServerlessNetworkPolicyUpdater.hasAcceptablePolicy(existingStatements, collectionName, vpceId)) {
                    LOG.info("Policy statement already exists that matches collection and vpce id");
                    return;
                }
                ArrayList<Document> statements = new ArrayList<Document>(existingStatements);
                statements.add(newStatement);
                Document newPolicy = Document.fromList(statements);
                this.updateNetworkPolicy(networkPolicyName, newPolicy, policyVersion);
            } else {
                Document newPolicy = Document.fromList(List.of(newStatement));
                this.createNetworkPolicy(networkPolicyName, newPolicy);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to create or update network policy", (Throwable)e);
        }
    }

    private Optional<SecurityPolicyDetail> getNetworkPolicy(String networkPolicyName) {
        GetSecurityPolicyResponse response;
        GetSecurityPolicyRequest getRequest = (GetSecurityPolicyRequest)GetSecurityPolicyRequest.builder().name(networkPolicyName).type(SecurityPolicyType.NETWORK).build();
        try {
            response = this.client.getSecurityPolicy(getRequest);
        }
        catch (ResourceNotFoundException e) {
            LOG.info("Could not find network policy {}", (Object)networkPolicyName);
            return Optional.empty();
        }
        if (response.securityPolicyDetail() == null) {
            LOG.info("Security policy exists but had no detail.");
            return Optional.empty();
        }
        return Optional.of(response.securityPolicyDetail());
    }

    private void createNetworkPolicy(String networkPolicyName, Document policy) {
        CreateSecurityPolicyRequest request = (CreateSecurityPolicyRequest)CreateSecurityPolicyRequest.builder().name(networkPolicyName).policy(policy.toString()).type(SecurityPolicyType.NETWORK).build();
        this.client.createSecurityPolicy(request);
    }

    private void updateNetworkPolicy(String networkPolicyName, Document policy, String policyVersion) {
        UpdateSecurityPolicyRequest request = (UpdateSecurityPolicyRequest)UpdateSecurityPolicyRequest.builder().name(networkPolicyName).policy(policy.toString()).type(SecurityPolicyType.NETWORK).policyVersion(policyVersion).build();
        this.client.updateSecurityPolicy(request);
    }

    private static Document createNetworkPolicyStatement(String collectionName, String vpceId) {
        return Document.mapBuilder().putString(DESCRIPTION, CREATED_BY_DATA_PREPPER).putList(RULES, List.of(Document.mapBuilder().putString(RESOURCE_TYPE, COLLECTION).putList(RESOURCE, List.of(Document.fromString((String)String.format("%s/%s", COLLECTION, collectionName)))).build())).putList(SOURCE_VPCES, List.of(Document.fromString((String)vpceId))).build();
    }

    private static boolean hasAcceptablePolicy(List<Document> statements, String collectionName, String vpceId) {
        for (Document statement : statements) {
            Map statementFields = statement.asMap();
            if (!statementFields.containsKey(SOURCE_VPCES) || !statementFields.containsKey(RULES)) continue;
            boolean hasMatchingVpce = ((Document)statementFields.get(SOURCE_VPCES)).asList().stream().map(Document::asString).anyMatch(vpce -> vpce.equals(vpceId));
            boolean hasMatchingCollection = ((Document)statementFields.get(RULES)).asList().stream().filter(rule -> ((Document)rule.asMap().get(RESOURCE_TYPE)).asString().equals(COLLECTION)).flatMap(rule -> ((Document)rule.asMap().get(RESOURCE)).asList().stream()).map(Document::asString).anyMatch(collectionPattern -> ServerlessNetworkPolicyUpdater.matchesPattern(collectionPattern, String.format("%s/%s", COLLECTION, collectionName)));
            if (!hasMatchingVpce || !hasMatchingCollection) continue;
            return true;
        }
        return false;
    }

    private static boolean matchesPattern(String pattern, String value) {
        String regex = "^" + Pattern.quote(pattern).replace("*", "\\E.*\\Q") + "$";
        return value.matches(regex);
    }
}

