/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.prometheus.service;

import com.google.common.annotations.VisibleForTesting;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.plugins.sink.prometheus.service.PrometheusSinkBufferEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.utils.Pair;

public class PrometheusSinkBufferWriterEntry {
    private static final Logger LOG = LoggerFactory.getLogger(PrometheusSinkBufferWriterEntry.class);
    private long lastSentTimestamp = -1L;
    private final int maxEntries;
    private final long windowMillis;
    private long seriesMaxTimestamp = -1L;
    private long realtimeSeriesMax;
    private final TreeMap<Long, PrometheusSinkBufferEntry> entries;

    public PrometheusSinkBufferWriterEntry(long windowMillis, int maxEntries) {
        this.maxEntries = maxEntries;
        this.windowMillis = windowMillis;
        this.entries = new TreeMap();
        this.realtimeSeriesMax = Instant.now().toEpochMilli();
    }

    public boolean add(PrometheusSinkBufferEntry bufferEntry) {
        long time = bufferEntry.getTimeSeries().getTimestamp();
        if (time <= this.lastSentTimestamp) {
            return false;
        }
        if (time > this.seriesMaxTimestamp) {
            this.seriesMaxTimestamp = time;
            this.realtimeSeriesMax = Instant.now().toEpochMilli();
        }
        this.entries.put(time, bufferEntry);
        if (this.entries.size() > this.maxEntries) {
            LOG.warn(DataPrepperMarkers.NOISY, "Number of entries exceeded maxEntries");
            return false;
        }
        return true;
    }

    public long getSize() {
        return this.entries.size();
    }

    @VisibleForTesting
    long windowSize() {
        long timeOffset = Instant.now().toEpochMilli() - this.realtimeSeriesMax;
        return this.seriesMaxTimestamp - this.windowMillis + timeOffset + 1L;
    }

    public long getNumberOfEntriesReadyToFlush() {
        SortedMap<Long, PrometheusSinkBufferEntry> readyToFlush = this.entries.headMap(this.windowSize());
        return readyToFlush.size();
    }

    public long getSizeOfEntriesReadyToFlush() {
        return this.entries.headMap(this.windowSize()).values().stream().mapToLong(entry -> entry.getTimeSeries().getSize()).sum();
    }

    public Pair<List<PrometheusSinkBufferEntry>, Long> getEntriesReadyToFlush(long maxEvents, long maxSize) {
        if (this.entries.isEmpty()) {
            return Pair.of(Collections.emptyList(), (Object)0L);
        }
        long cutoff = this.windowSize();
        ArrayList<PrometheusSinkBufferEntry> toFlush = new ArrayList<PrometheusSinkBufferEntry>();
        SortedMap<Long, PrometheusSinkBufferEntry> readyToFlush = this.entries.headMap(cutoff);
        long curSize = 0L;
        if (!readyToFlush.isEmpty()) {
            Map.Entry<Long, PrometheusSinkBufferEntry> entry;
            long entrySize;
            Iterator<Map.Entry<Long, PrometheusSinkBufferEntry>> iterator = readyToFlush.entrySet().iterator();
            for (long numEntries = 0L; iterator.hasNext() && numEntries < maxEvents && curSize + (entrySize = (long)(entry = iterator.next()).getValue().getTimeSeries().getSize()) <= maxSize; ++numEntries) {
                curSize += entrySize;
                toFlush.add(entry.getValue());
                iterator.remove();
            }
        }
        if (!toFlush.isEmpty()) {
            toFlush.sort(Comparator.comparing(bufferEntry -> bufferEntry.getTimeSeries().getTimestamp()));
            this.lastSentTimestamp = ((PrometheusSinkBufferEntry)toFlush.get(toFlush.size() - 1)).getTimeSeries().getTimestamp();
        }
        return Pair.of(toFlush, (Object)curSize);
    }
}

