/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.logstash.mapping;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opensearch.dataprepper.logstash.mapping.AbstractLogstashPluginAttributesMapper;
import org.opensearch.dataprepper.logstash.mapping.LogstashAttributesMappings;
import org.opensearch.dataprepper.logstash.model.LogstashAttribute;

class OpenSearchPluginAttributesMapper
extends AbstractLogstashPluginAttributesMapper {
    private static final Map<Character, Character> PATTERN_CONVERTER_MAP = new HashMap<Character, Character>();
    protected static final String LOGSTASH_OPENSEARCH_INDEX_ATTRIBUTE_NAME = "index";
    protected static final String REGEX_EXTRACTING_DATETIME_PATTERN = "%\\{([+].*?)\\}";

    OpenSearchPluginAttributesMapper() {
    }

    @Override
    protected void mapCustomAttributes(List<LogstashAttribute> logstashAttributes, LogstashAttributesMappings logstashAttributesMappings, Map<String, Object> pluginSettings) {
        Optional<String> convertedIndexAttributeValue = logstashAttributes.stream().filter(a -> a.getAttributeName().equals(LOGSTASH_OPENSEARCH_INDEX_ATTRIBUTE_NAME)).map(this::findAndMatchDateTimePattern).findFirst();
        convertedIndexAttributeValue.ifPresent(s -> pluginSettings.put(logstashAttributesMappings.getMappedAttributeNames().get(LOGSTASH_OPENSEARCH_INDEX_ATTRIBUTE_NAME), s));
    }

    @Override
    protected HashSet<String> getCustomMappedAttributeNames() {
        return new HashSet<String>(Collections.singletonList(LOGSTASH_OPENSEARCH_INDEX_ATTRIBUTE_NAME));
    }

    private String findAndMatchDateTimePattern(LogstashAttribute logstashAttribute) {
        String logstashIndexAttributeValue = logstashAttribute.getAttributeValue().getValue().toString();
        Pattern dateTimeRegexPattern = Pattern.compile(REGEX_EXTRACTING_DATETIME_PATTERN);
        Matcher dateTimePatternMatcher = dateTimeRegexPattern.matcher(logstashIndexAttributeValue);
        if (dateTimePatternMatcher.find()) {
            String dateTimePattern = dateTimePatternMatcher.group(0);
            return logstashIndexAttributeValue.replace(dateTimePattern, this.convertDateTimePattern(dateTimePattern));
        }
        return logstashIndexAttributeValue;
    }

    private String convertDateTimePattern(String dateTimePattern) {
        StringBuilder updatedDateTimePattern = new StringBuilder();
        for (char character : dateTimePattern.toCharArray()) {
            if (character == '+') continue;
            char converterChar = PATTERN_CONVERTER_MAP.getOrDefault(Character.valueOf(character), Character.valueOf(character)).charValue();
            updatedDateTimePattern.append(converterChar);
        }
        return updatedDateTimePattern.toString();
    }

    static {
        PATTERN_CONVERTER_MAP.put(Character.valueOf('y'), Character.valueOf('u'));
        PATTERN_CONVERTER_MAP.put(Character.valueOf('Y'), Character.valueOf('y'));
        PATTERN_CONVERTER_MAP.put(Character.valueOf('x'), Character.valueOf('Y'));
    }
}

