/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.logstash;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.opensearch.dataprepper.logstash.LogstashLexer;
import org.opensearch.dataprepper.logstash.LogstashParser;
import org.opensearch.dataprepper.logstash.mapping.LogstashMapper;
import org.opensearch.dataprepper.logstash.model.LogstashConfiguration;
import org.opensearch.dataprepper.logstash.parser.ModelConvertingLogstashVisitor;
import org.opensearch.dataprepper.model.configuration.PipelineModel;
import org.opensearch.dataprepper.model.configuration.PipelinesDataFlowModel;

public class LogstashConfigConverter {
    public String convertLogstashConfigurationToPipeline(String logstashConfigurationPath, String outputDirectory) throws IOException {
        Path configurationFilePath = Paths.get(logstashConfigurationPath, new String[0]);
        String logstashConfigAsString = new String(Files.readAllBytes(configurationFilePath));
        LogstashLexer lexer = new LogstashLexer((CharStream)CharStreams.fromString((String)logstashConfigAsString));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        LogstashParser parser = new LogstashParser((TokenStream)tokens);
        LogstashParser.ConfigContext tree = parser.config();
        ModelConvertingLogstashVisitor visitor = new ModelConvertingLogstashVisitor();
        LogstashConfiguration logstashConfiguration = (LogstashConfiguration)visitor.visit((ParseTree)tree);
        LogstashMapper logstashMapper = new LogstashMapper();
        PipelineModel pipelineModel = logstashMapper.mapPipeline(logstashConfiguration);
        PipelinesDataFlowModel pipelinesDataFlowModel = new PipelinesDataFlowModel(Collections.singletonMap("logstash-converted-pipeline", pipelineModel));
        ObjectMapper mapper = new ObjectMapper((JsonFactory)YAMLFactory.builder().disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER).enable(YAMLGenerator.Feature.INDENT_ARRAYS_WITH_INDICATOR).enable(YAMLGenerator.Feature.USE_PLATFORM_LINE_BREAKS).disable(YAMLGenerator.Feature.SPLIT_LINES).enable(YAMLGenerator.Feature.LITERAL_BLOCK_STYLE).build());
        String confFileName = configurationFilePath.getFileName().toString();
        String yamlFileName = confFileName.substring(0, confFileName.lastIndexOf(".conf"));
        Path yamlFilePath = Paths.get(outputDirectory, yamlFileName + ".yaml");
        mapper.writeValue(new File(String.valueOf(yamlFilePath)), (Object)pipelinesDataFlowModel);
        return String.valueOf(yamlFilePath);
    }
}

