/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.examples.parkservices;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.config.ScoringStrategy;
import com.amazon.randomcutforest.config.TransformMethod;
import com.amazon.randomcutforest.examples.Example;
import com.amazon.randomcutforest.parkservices.AnomalyDescriptor;
import com.amazon.randomcutforest.parkservices.ThresholdedRandomCutForest;
import com.amazon.randomcutforest.testutils.MultiDimDataWithKey;
import com.amazon.randomcutforest.testutils.ShingledMultiDimDataWithKeys;
import java.util.Arrays;
import java.util.Random;

public class ScoringStrategyExample
implements Example {
    public static void main(String[] args) throws Exception {
        new ScoringStrategyExample().run();
    }

    @Override
    public String command() {
        return "Scoring_strategy_example";
    }

    @Override
    public String description() {
        return "Scoring Strategy Example";
    }

    @Override
    public void run() throws Exception {
        int shingleSize = 4;
        int numberOfTrees = 50;
        int sampleSize = 256;
        int dataSize = 4 * sampleSize;
        int baseDimensions = 1;
        long seed = new Random().nextLong();
        long count = 0L;
        int dimensions = baseDimensions * shingleSize;
        TransformMethod transformMethod = TransformMethod.NORMALIZE;
        ThresholdedRandomCutForest forest = ThresholdedRandomCutForest.builder().compact(true).dimensions(dimensions).randomSeed(seed).numberOfTrees(numberOfTrees).shingleSize(shingleSize).sampleSize(sampleSize).internalShinglingEnabled(true).scoringStrategy(ScoringStrategy.EXPECTED_INVERSE_DEPTH).transformMethod(transformMethod).outputAfter(32).initialAcceptFraction(0.125).build();
        ThresholdedRandomCutForest second = ThresholdedRandomCutForest.builder().compact(true).dimensions(dimensions).randomSeed(seed).numberOfTrees(numberOfTrees).shingleSize(shingleSize).sampleSize(sampleSize).internalShinglingEnabled(true).scoringStrategy(ScoringStrategy.MULTI_MODE).transformMethod(transformMethod).outputAfter(32).initialAcceptFraction(0.125).build();
        ThresholdedRandomCutForest third = ThresholdedRandomCutForest.builder().compact(true).dimensions(dimensions).randomSeed(seed).numberOfTrees(numberOfTrees).shingleSize(shingleSize).sampleSize(sampleSize).internalShinglingEnabled(true).scoringStrategy(ScoringStrategy.MULTI_MODE_RECALL).transformMethod(transformMethod).outputAfter(32).initialAcceptFraction(0.125).build();
        System.out.println("seed = " + seed);
        MultiDimDataWithKey dataWithKeys = ShingledMultiDimDataWithKeys.getMultiDimData((int)(dataSize + shingleSize - 1), (int)50, (double)100.0, (double)5.0, (long)seed, (int)baseDimensions);
        int keyCounter = 0;
        for (double[] point : dataWithKeys.data) {
            AnomalyDescriptor result = forest.process(point, 0L);
            AnomalyDescriptor multi_mode = second.process(point, 0L);
            AnomalyDescriptor multi_mode_recall = third.process(point, 0L);
            CommonUtils.checkArgument((Math.abs(result.getRCFScore() - multi_mode.getRCFScore()) < 1.0E-10 ? 1 : 0) != 0, (String)" error");
            CommonUtils.checkArgument((Math.abs(result.getRCFScore() - multi_mode_recall.getRCFScore()) < 1.0E-10 ? 1 : 0) != 0, (String)" error");
            if (keyCounter < dataWithKeys.changeIndices.length && count == (long)dataWithKeys.changeIndices[keyCounter]) {
                System.out.println("timestamp " + count + " CHANGE " + Arrays.toString(dataWithKeys.changes[keyCounter]));
                ++keyCounter;
            }
            this.printResult("MULTI_MODE_RECALL", multi_mode_recall, count, baseDimensions);
            this.printResult("EXPECTED_INVERSE_DEPTH", result, count, baseDimensions);
            this.printResult("MULTI_MODE", multi_mode, count, baseDimensions);
            ++count;
        }
    }

    void printResult(String description, AnomalyDescriptor result, long count, int baseDimensions) {
        if (result.getAnomalyGrade() != 0.0) {
            int i;
            System.out.print(description + " timestamp " + count + " RESULT value ");
            for (i = 0; i < baseDimensions; ++i) {
                System.out.print(result.getCurrentInput()[i] + ", ");
            }
            System.out.print("score " + result.getRCFScore() + ", grade " + result.getAnomalyGrade() + ", ");
            if (result.getRelativeIndex() != 0) {
                System.out.print(-result.getRelativeIndex() + " steps ago, ");
            }
            if (result.isExpectedValuesPresent()) {
                if (result.getRelativeIndex() != 0) {
                    System.out.print("instead of ");
                    for (i = 0; i < baseDimensions; ++i) {
                        System.out.print(result.getPastValues()[i] + ", ");
                    }
                    System.out.print("expected ");
                    for (i = 0; i < baseDimensions; ++i) {
                        System.out.print(result.getExpectedValuesList()[0][i] + ", ");
                        if (result.getPastValues()[i] == result.getExpectedValuesList()[0][i]) continue;
                        System.out.print("( " + (result.getPastValues()[i] - result.getExpectedValuesList()[0][i]) + " ) ");
                    }
                } else {
                    System.out.print("expected ");
                    for (i = 0; i < baseDimensions; ++i) {
                        System.out.print(result.getExpectedValuesList()[0][i] + ", ");
                        if (result.getCurrentInput()[i] == result.getExpectedValuesList()[0][i]) continue;
                        System.out.print("( " + (result.getCurrentInput()[i] - result.getExpectedValuesList()[0][i]) + " ) ");
                    }
                }
            } else {
                System.out.print("insufficient data to provide expected values");
            }
            System.out.println();
        }
    }
}

