/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.bouncycastle.asn1.x509;

import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1EncodableVector;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1Object;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1Primitive;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1Sequence;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.DERSequence;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.x509.Extension;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Extensions
extends ASN1Object {
    private Hashtable extensions = new Hashtable();
    private Vector ordering = new Vector();

    public static Extensions getInstance(Object object) {
        if (object instanceof Extensions) {
            return (Extensions)object;
        }
        if (object != null) {
            return new Extensions(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private Extensions(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            Extension extension = Extension.getInstance(enumeration.nextElement());
            if (this.extensions.containsKey(extension.getExtnId())) {
                throw new IllegalArgumentException("repeated extension found: " + extension.getExtnId());
            }
            this.extensions.put(extension.getExtnId(), extension);
            this.ordering.addElement(extension.getExtnId());
        }
    }

    public Extensions(Extension[] extensionArray) {
        for (int i = 0; i != extensionArray.length; ++i) {
            Extension extension = extensionArray[i];
            this.ordering.addElement(extension.getExtnId());
            this.extensions.put(extension.getExtnId(), extension);
        }
    }

    public Enumeration oids() {
        return this.ordering.elements();
    }

    public Extension getExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return (Extension)this.extensions.get(aSN1ObjectIdentifier);
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(this.ordering.size());
        Enumeration enumeration = this.ordering.elements();
        while (enumeration.hasMoreElements()) {
            ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)enumeration.nextElement();
            Extension extension = (Extension)this.extensions.get(aSN1ObjectIdentifier);
            aSN1EncodableVector.add(extension);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

