/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.otel.common;

import java.util.Map;
import org.opensearch.dataprepper.plugins.otel.common.OTelSpanDerivationUtil;

class ServiceEnvironmentProviders {
    ServiceEnvironmentProviders() {
    }

    public static String getDeploymentEnvironment(Map<String, Object> spanAttributes) {
        try {
            Map resourceAttrs = (Map)((Map)spanAttributes.get("resource")).get("attributes");
            String env = OTelSpanDerivationUtil.getStringAttribute(resourceAttrs, "deployment.environment.name");
            if (env != null && !env.trim().isEmpty()) {
                return env;
            }
            env = OTelSpanDerivationUtil.getStringAttribute(resourceAttrs, "deployment.environment");
            if (env != null && !env.trim().isEmpty()) {
                return env;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "generic:default";
    }

    public static String getAwsServiceEnvironment(Map<String, Object> spanAttributes) {
        try {
            String cloudPlatform = OTelSpanDerivationUtil.getStringAttribute(spanAttributes, "cloud.platform");
            if (cloudPlatform != null && cloudPlatform.equals("aws_api_gateway")) {
                return "api-gateway:" + OTelSpanDerivationUtil.getStringAttribute(spanAttributes, "aws.api_gateway.stage");
            }
            if (cloudPlatform != null && cloudPlatform.equals("aws_ec2")) {
                return "ec2:default";
            }
            String cloudResourceId = OTelSpanDerivationUtil.getStringAttribute(spanAttributes, "cloud.resource_id");
            String invokedArn = OTelSpanDerivationUtil.getStringAttribute(spanAttributes, "aws.lambda.invoked_arn");
            if (cloudResourceId != null && cloudResourceId.startsWith("arn:aws:lambda:") || invokedArn != null) {
                return "lambda:default";
            }
            Map resourceAttributes = (Map)((Map)spanAttributes.get("resource")).get("attributes");
            String cloudProvider = OTelSpanDerivationUtil.getStringAttribute(resourceAttributes, "cloud.provider");
            String faasName = OTelSpanDerivationUtil.getStringAttribute(resourceAttributes, "faas.name");
            if (cloudProvider != null && cloudProvider.equals("aws") && faasName != null) {
                return "lambda:default";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

