/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.mapping;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class KnnVectorMethod
implements PlainJsonSerializable {
    @Nullable
    private final String engine;
    @Nonnull
    private final String name;
    @Nonnull
    private final Map<String, JsonData> parameters;
    @Nullable
    private final String spaceType;
    public static final JsonpDeserializer<KnnVectorMethod> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, KnnVectorMethod::setupKnnVectorMethodDeserializer);

    private KnnVectorMethod(Builder builder) {
        this.engine = builder.engine;
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.parameters = ApiTypeHelper.unmodifiable(builder.parameters);
        this.spaceType = builder.spaceType;
    }

    public static KnnVectorMethod of(Function<Builder, ObjectBuilder<KnnVectorMethod>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String engine() {
        return this.engine;
    }

    @Nonnull
    public final String name() {
        return this.name;
    }

    @Nonnull
    public final Map<String, JsonData> parameters() {
        return this.parameters;
    }

    @Nullable
    public final String spaceType() {
        return this.spaceType;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.engine != null) {
            generator.writeKey("engine");
            generator.write(this.engine);
        }
        generator.writeKey("name");
        generator.write(this.name);
        if (ApiTypeHelper.isDefined(this.parameters)) {
            generator.writeKey("parameters");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.parameters.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.spaceType != null) {
            generator.writeKey("space_type");
            generator.write(this.spaceType);
        }
    }

    protected static void setupKnnVectorMethodDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::engine, JsonpDeserializer.stringDeserializer(), "engine");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::parameters, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "parameters");
        op.add(Builder::spaceType, JsonpDeserializer.stringDeserializer(), "space_type");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.engine);
        result = 31 * result + this.name.hashCode();
        result = 31 * result + Objects.hashCode(this.parameters);
        result = 31 * result + Objects.hashCode(this.spaceType);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KnnVectorMethod other = (KnnVectorMethod)o;
        return Objects.equals(this.engine, other.engine) && this.name.equals(other.name) && Objects.equals(this.parameters, other.parameters) && Objects.equals(this.spaceType, other.spaceType);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<KnnVectorMethod> {
        @Nullable
        private String engine;
        private String name;
        @Nullable
        private Map<String, JsonData> parameters;
        @Nullable
        private String spaceType;

        public final Builder engine(@Nullable String value) {
            this.engine = value;
            return this;
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder parameters(Map<String, JsonData> map) {
            this.parameters = Builder._mapPutAll(this.parameters, map);
            return this;
        }

        public final Builder parameters(String key, JsonData value) {
            this.parameters = Builder._mapPut(this.parameters, key, value);
            return this;
        }

        public final Builder spaceType(@Nullable String value) {
            this.spaceType = value;
            return this;
        }

        @Override
        public KnnVectorMethod build() {
            this._checkSingleUse();
            return new KnnVectorMethod(this);
        }
    }
}

