/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.mutatestring;

import java.util.Collection;
import java.util.List;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventKey;
import org.opensearch.dataprepper.model.processor.AbstractProcessor;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.processor.mutatestring.StringProcessorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStringProcessor<T>
extends AbstractProcessor<Record<Event>, Record<Event>> {
    private final List<T> entries;
    static final Logger LOG = LoggerFactory.getLogger(AbstractStringProcessor.class);

    @DataPrepperPluginConstructor
    public AbstractStringProcessor(PluginMetrics pluginMetrics, StringProcessorConfig<T> config) {
        super(pluginMetrics);
        this.entries = config.getIterativeConfig();
    }

    public Collection<Record<Event>> doExecute(Collection<Record<Event>> records) {
        for (Record<Event> record : records) {
            Event recordEvent = (Event)record.getData();
            try {
                this.performStringAction(recordEvent);
            }
            catch (Exception e) {
                LOG.error(DataPrepperMarkers.NOISY, "There was an exception while processing Event [{}]", (Object)recordEvent, (Object)e);
                LOG.atError().addMarker(DataPrepperMarkers.EVENT).addMarker(DataPrepperMarkers.NOISY).setMessage("There was an exception while processing Event [{}]").addArgument((Object)recordEvent).setCause((Throwable)e).log();
            }
        }
        return records;
    }

    private void performStringAction(Event recordEvent) {
        try {
            for (T entry : this.entries) {
                Object value;
                EventKey key = this.getKey(entry);
                if (!recordEvent.containsKey(key) || !((value = recordEvent.get(key, Object.class)) instanceof String)) continue;
                this.performKeyAction(recordEvent, entry, (String)value);
            }
        }
        catch (Exception e) {
            LOG.error(DataPrepperMarkers.EVENT, "Exception while performing String action", (Throwable)e);
        }
    }

    protected abstract void performKeyAction(Event var1, T var2, String var3);

    protected abstract EventKey getKey(T var1);

    public void prepareForShutdown() {
    }

    public boolean isReadyForShutdown() {
        return true;
    }

    public void shutdown() {
    }
}

