/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.codec.newline;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.codec.OutputCodec;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.sink.OutputCodecContext;
import org.opensearch.dataprepper.plugins.codec.newline.NewlineDelimitedOutputConfig;

@DataPrepperPlugin(name="newline", pluginType=OutputCodec.class, pluginConfigurationType=NewlineDelimitedOutputConfig.class)
public class NewlineDelimitedOutputCodec
implements OutputCodec {
    private static final String NEWLINE = "txt";
    private static final String MESSAGE_FIELD = "message";
    private OutputCodecContext deprecatedSupportCodecContext;
    private final boolean includeEmptyObjects;

    @DataPrepperPluginConstructor
    public NewlineDelimitedOutputCodec(NewlineDelimitedOutputConfig config) {
        Objects.requireNonNull(config);
        this.includeEmptyObjects = config.isIncludeEmptyObjects();
    }

    public OutputCodec.Writer createWriter(OutputStream outputStream, Event sampleEvent, OutputCodecContext codecContext) throws IOException {
        Objects.requireNonNull(outputStream);
        Objects.requireNonNull(codecContext);
        return new NewlineWriter(outputStream, codecContext, this.includeEmptyObjects);
    }

    public void start(OutputStream outputStream, Event event, OutputCodecContext codecContext) throws IOException {
        Objects.requireNonNull(outputStream);
        Objects.requireNonNull(codecContext);
        this.deprecatedSupportCodecContext = codecContext;
    }

    public void writeEvent(Event event, OutputStream outputStream) throws IOException {
        NewlineDelimitedOutputCodec.doWriteEvent(outputStream, event, this.deprecatedSupportCodecContext, this.includeEmptyObjects);
    }

    public void complete(OutputStream outputStream) throws IOException {
        outputStream.close();
    }

    public String getExtension() {
        return NEWLINE;
    }

    private static void doWriteEvent(OutputStream outputStream, Event event, OutputCodecContext codecContext, boolean includeEmptyObjects) throws IOException {
        Object messageObj;
        Objects.requireNonNull(event);
        String message = null;
        if (event.containsKey(MESSAGE_FIELD) && (messageObj = event.get(MESSAGE_FIELD, Object.class)) != null) {
            message = messageObj.toString();
        }
        if (message == null || message.isEmpty()) {
            if (!includeEmptyObjects) {
                return;
            }
            message = "";
        }
        outputStream.write(message.getBytes());
        outputStream.write(System.lineSeparator().getBytes());
    }

    private static class NewlineWriter
    implements OutputCodec.Writer {
        private final OutputStream outputStream;
        private final OutputCodecContext codecContext;
        private final boolean includeEmptyObjects;

        private NewlineWriter(OutputStream outputStream, OutputCodecContext codecContext, boolean includeEmptyObjects) {
            this.outputStream = outputStream;
            this.codecContext = codecContext;
            this.includeEmptyObjects = includeEmptyObjects;
        }

        public void writeEvent(Event event) throws IOException {
            NewlineDelimitedOutputCodec.doWriteEvent(this.outputStream, event, this.codecContext, this.includeEmptyObjects);
        }

        public void complete() throws IOException {
            this.outputStream.close();
        }
    }
}

