/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugin;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validator;
import jakarta.validation.constraints.AssertTrue;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.opensearch.dataprepper.model.configuration.PluginSetting;
import org.opensearch.dataprepper.model.plugin.InvalidPluginConfigurationException;
import org.opensearch.dataprepper.plugin.PluginConfigurationErrorHandler;
import org.springframework.context.annotation.DependsOn;

@Named
@DependsOn(value={"extensionsApplier"})
class PluginConfigurationConverter {
    static final TypeReference<Map<String, Object>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};
    private final ObjectMapper objectMapper;
    private final Validator validator;
    private final PluginConfigurationErrorHandler pluginConfigurationErrorHandler;

    PluginConfigurationConverter(Validator validator, @Named(value="pluginConfigObjectMapper") ObjectMapper objectMapper, PluginConfigurationErrorHandler pluginConfigurationErrorHandler) {
        this.objectMapper = objectMapper;
        this.validator = validator;
        this.pluginConfigurationErrorHandler = pluginConfigurationErrorHandler;
    }

    public Object convert(Class<?> pluginConfigurationType, PluginSetting pluginSetting) {
        Objects.requireNonNull(pluginConfigurationType);
        Objects.requireNonNull(pluginSetting);
        if (pluginConfigurationType.equals(PluginSetting.class)) {
            Map settings = pluginSetting.getSettings();
            Map convertedSettings = (Map)this.objectMapper.convertValue((Object)settings, MAP_TYPE_REFERENCE);
            pluginSetting.setSettings(convertedSettings);
            return pluginSetting;
        }
        Object configuration = this.convertSettings(pluginConfigurationType, pluginSetting);
        Set constraintViolations = this.validator.validate(configuration, new Class[0]);
        if (!constraintViolations.isEmpty()) {
            String violationsString = constraintViolations.stream().map(this::constructConstrainViolationMessage).collect(Collectors.joining(". "));
            String exceptionMessage = String.format("Plugin %s in pipeline %s is configured incorrectly: %s", pluginSetting.getName(), pluginSetting.getPipelineName(), violationsString);
            throw new InvalidPluginConfigurationException(exceptionMessage);
        }
        return configuration;
    }

    private Object convertSettings(Class<?> pluginConfigurationType, PluginSetting pluginSetting) {
        Map settingsMap = pluginSetting.getSettings();
        if (settingsMap == null) {
            settingsMap = Collections.emptyMap();
        }
        try {
            return this.objectMapper.convertValue(settingsMap, pluginConfigurationType);
        }
        catch (Exception e) {
            throw this.pluginConfigurationErrorHandler.handleException(pluginSetting, e);
        }
    }

    private String constructConstrainViolationMessage(ConstraintViolation<Object> constraintViolation) {
        if (constraintViolation.getConstraintDescriptor().getAnnotation().annotationType().equals(AssertTrue.class)) {
            return constraintViolation.getMessage();
        }
        return constraintViolation.getPropertyPath().toString() + " " + constraintViolation.getMessage();
    }
}

