/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.util;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Timer;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaTopicConsumerMetrics {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaTopicConsumerMetrics.class);
    static final String NUMBER_OF_POSITIVE_ACKNOWLEDGEMENTS = "numberOfPositiveAcknowledgements";
    static final String NUMBER_OF_NEGATIVE_ACKNOWLEDGEMENTS = "numberOfNegativeAcknowledgements";
    static final String NUMBER_OF_RECORDS_FAILED_TO_PARSE = "numberOfRecordsFailedToParse";
    static final String NUMBER_OF_DESERIALIZATION_ERRORS = "numberOfDeserializationErrors";
    static final String NUMBER_OF_BUFFER_SIZE_OVERFLOWS = "numberOfBufferSizeOverflows";
    static final String NUMBER_OF_INVALID_TIMESTAMPS = "numberOfInvalidTimeStamps";
    static final String NUMBER_OF_POLL_AUTH_ERRORS = "numberOfPollAuthErrors";
    static final String NUMBER_OF_RECORDS_COMMITTED = "numberOfRecordsCommitted";
    static final String NUMBER_OF_RECORDS_CONSUMED = "numberOfRecordsConsumed";
    static final String NUMBER_OF_BYTES_CONSUMED = "numberOfBytesConsumed";
    static final String ACTUAL_POLL_INTERVAL = "actualPollInterval";
    private final String topicName;
    private long updateTime;
    private Map<String, String> metricsNameMap;
    private Map<KafkaConsumer, Map<String, Double>> metricValues;
    private final PluginMetrics pluginMetrics;
    private final Counter numberOfPositiveAcknowledgements;
    private final Counter numberOfNegativeAcknowledgements;
    private final Counter numberOfRecordsFailedToParse;
    private final Counter numberOfDeserializationErrors;
    private final Counter numberOfBufferSizeOverflows;
    private final Counter numberOfPollAuthErrors;
    private final Counter numberOfInvalidTimeStamps;
    private final Counter numberOfRecordsCommitted;
    private final Counter numberOfRecordsConsumed;
    private final Counter numberOfBytesConsumed;
    private final Timer timeBetweenPollCalls;
    private Instant lastPollTime;

    public KafkaTopicConsumerMetrics(String topicName, PluginMetrics pluginMetrics, boolean topicNameInMetrics) {
        this.pluginMetrics = pluginMetrics;
        this.topicName = topicName;
        this.updateTime = Instant.now().getEpochSecond();
        this.metricValues = new HashMap<KafkaConsumer, Map<String, Double>>();
        this.initializeMetricNamesMap(topicNameInMetrics);
        this.numberOfRecordsConsumed = pluginMetrics.counter(this.getTopicMetricName(NUMBER_OF_RECORDS_CONSUMED, topicNameInMetrics));
        this.numberOfBytesConsumed = pluginMetrics.counter(this.getTopicMetricName(NUMBER_OF_BYTES_CONSUMED, topicNameInMetrics));
        this.numberOfRecordsCommitted = pluginMetrics.counter(this.getTopicMetricName(NUMBER_OF_RECORDS_COMMITTED, topicNameInMetrics));
        this.numberOfRecordsFailedToParse = pluginMetrics.counter(this.getTopicMetricName(NUMBER_OF_RECORDS_FAILED_TO_PARSE, topicNameInMetrics));
        this.numberOfInvalidTimeStamps = pluginMetrics.counter(this.getTopicMetricName(NUMBER_OF_INVALID_TIMESTAMPS, topicNameInMetrics));
        this.numberOfDeserializationErrors = pluginMetrics.counter(this.getTopicMetricName(NUMBER_OF_DESERIALIZATION_ERRORS, topicNameInMetrics));
        this.numberOfBufferSizeOverflows = pluginMetrics.counter(this.getTopicMetricName(NUMBER_OF_BUFFER_SIZE_OVERFLOWS, topicNameInMetrics));
        this.numberOfPollAuthErrors = pluginMetrics.counter(this.getTopicMetricName(NUMBER_OF_POLL_AUTH_ERRORS, topicNameInMetrics));
        this.numberOfPositiveAcknowledgements = pluginMetrics.counter(this.getTopicMetricName(NUMBER_OF_POSITIVE_ACKNOWLEDGEMENTS, topicNameInMetrics));
        this.numberOfNegativeAcknowledgements = pluginMetrics.counter(this.getTopicMetricName(NUMBER_OF_NEGATIVE_ACKNOWLEDGEMENTS, topicNameInMetrics));
        this.timeBetweenPollCalls = pluginMetrics.timer(this.getTopicMetricName(ACTUAL_POLL_INTERVAL, topicNameInMetrics));
        this.lastPollTime = Instant.now();
    }

    private void initializeMetricNamesMap(boolean topicNameInMetrics) {
        this.metricsNameMap = new HashMap<String, String>();
        this.metricsNameMap.put("bytes-consumed-total", "bytesConsumedTotal");
        this.metricsNameMap.put("records-consumed-total", "recordsConsumedTotal");
        this.metricsNameMap.put("bytes-consumed-rate", "bytesConsumedRate");
        this.metricsNameMap.put("records-consumed-rate", "recordsConsumedRate");
        this.metricsNameMap.put("records-lag-max", "recordsLagMax");
        this.metricsNameMap.put("records-lead-min", "recordsLeadMin");
        this.metricsNameMap.put("commit-rate", "commitRate");
        this.metricsNameMap.put("join-rate", "joinRate");
        this.metricsNameMap.put("incoming-byte-rate", "incomingByteRate");
        this.metricsNameMap.put("outgoing-byte-rate", "outgoingByteRate");
        this.metricsNameMap.put("assigned-partitions", "numberOfNonConsumers");
        this.metricsNameMap.forEach((metricName, camelCaseName) -> {
            if (metricName.equals("records-lag-max")) {
                this.pluginMetrics.gauge(this.getTopicMetricName((String)camelCaseName, topicNameInMetrics), this.metricValues, metricValues -> {
                    double max = 0.0;
                    for (Map.Entry entry : metricValues.entrySet()) {
                        Map consumerMetrics;
                        Map map = consumerMetrics = (Map)entry.getValue();
                        synchronized (map) {
                            if (consumerMetrics.get(metricName) == null) {
                                LOG.debug("No consumer metric for recordsLagMax found");
                            }
                            max = Math.max(max, (Double)consumerMetrics.get(metricName));
                        }
                    }
                    return max;
                });
            } else if (metricName.equals("records-lead-min")) {
                this.pluginMetrics.gauge(this.getTopicMetricName((String)camelCaseName, topicNameInMetrics), this.metricValues, metricValues -> {
                    double min = Double.MAX_VALUE;
                    for (Map.Entry entry : metricValues.entrySet()) {
                        Map consumerMetrics;
                        Map map = consumerMetrics = (Map)entry.getValue();
                        synchronized (map) {
                            min = Math.min(min, (Double)consumerMetrics.get(metricName));
                        }
                    }
                    return min;
                });
            } else if (!metricName.contains("-total")) {
                this.pluginMetrics.gauge(this.getTopicMetricName((String)camelCaseName, topicNameInMetrics), this.metricValues, metricValues -> {
                    double sum = 0.0;
                    for (Map.Entry entry : metricValues.entrySet()) {
                        Map consumerMetrics;
                        Map map = consumerMetrics = (Map)entry.getValue();
                        synchronized (map) {
                            sum += ((Double)consumerMetrics.get(metricName)).doubleValue();
                        }
                    }
                    return sum;
                });
            }
        });
    }

    public void register(KafkaConsumer consumer) {
        this.metricValues.put(consumer, new HashMap());
        Map<String, Double> consumerMetrics = this.metricValues.get(consumer);
        this.metricsNameMap.forEach((k, name) -> consumerMetrics.put((String)k, 0.0));
    }

    Counter getNumberOfRecordsConsumed() {
        return this.numberOfRecordsConsumed;
    }

    Counter getNumberOfBytesConsumed() {
        return this.numberOfBytesConsumed;
    }

    public Counter getNumberOfRecordsCommitted() {
        return this.numberOfRecordsCommitted;
    }

    public Counter getNumberOfPollAuthErrors() {
        return this.numberOfPollAuthErrors;
    }

    public Counter getNumberOfBufferSizeOverflows() {
        return this.numberOfBufferSizeOverflows;
    }

    public Counter getNumberOfDeserializationErrors() {
        return this.numberOfDeserializationErrors;
    }

    public Counter getNumberOfRecordsFailedToParse() {
        return this.numberOfRecordsFailedToParse;
    }

    public Counter getNumberOfNegativeAcknowledgements() {
        return this.numberOfNegativeAcknowledgements;
    }

    public Counter getNumberOfInvalidTimeStamps() {
        return this.numberOfInvalidTimeStamps;
    }

    public Counter getNumberOfPositiveAcknowledgements() {
        return this.numberOfPositiveAcknowledgements;
    }

    public void recordTimeBetweenPolls() {
        long timeBetweenPolls = Instant.now().toEpochMilli() - this.lastPollTime.toEpochMilli();
        this.timeBetweenPollCalls.record(timeBetweenPolls, TimeUnit.MILLISECONDS);
        this.lastPollTime = Instant.now();
    }

    private String getTopicMetricName(String metricName, boolean topicNameInMetrics) {
        if (topicNameInMetrics) {
            return "topic." + this.topicName + "." + metricName;
        }
        return metricName;
    }

    private String getCamelCaseName(String name) {
        String camelCaseName = this.metricsNameMap.get(name);
        if (Objects.isNull(camelCaseName)) {
            return name;
        }
        return camelCaseName;
    }

    Map<KafkaConsumer, Map<String, Double>> getMetricValues() {
        return this.metricValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(KafkaConsumer consumer) {
        Map<String, Double> consumerMetrics = this.metricValues.get(consumer);
        Map metrics = consumer.metrics();
        for (Map.Entry entry : metrics.entrySet()) {
            double prevValue;
            Map<String, Double> map;
            MetricName metric = (MetricName)entry.getKey();
            Metric value = (Metric)entry.getValue();
            String metricName = metric.name();
            if (!Objects.nonNull(this.metricsNameMap.get(metricName)) || metric.tags().containsKey("partition") && (metricName.equals("records-lag-max") || metricName.equals("records-lead-min")) || metricName.contains("consumed-total") && !metric.tags().containsKey("topic") || metricName.contains("byte-rate") && metric.tags().containsKey("node-id")) continue;
            double newValue = (Double)value.metricValue();
            if (metricName.equals("records-consumed-total")) {
                map = consumerMetrics;
                synchronized (map) {
                    prevValue = consumerMetrics.get(metricName);
                    this.numberOfRecordsConsumed.increment(newValue - prevValue);
                }
            }
            if (metricName.equals("bytes-consumed-total")) {
                map = consumerMetrics;
                synchronized (map) {
                    prevValue = consumerMetrics.get(metricName);
                    this.numberOfBytesConsumed.increment(newValue - prevValue);
                }
            }
            if (metricName.equals("assigned-partitions")) {
                newValue = newValue == 0.0 ? 1.0 : 0.0;
            }
            map = consumerMetrics;
            synchronized (map) {
                consumerMetrics.put(metricName, newValue);
            }
        }
    }
}

