/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.util;

import com.amazonaws.services.schemaregistry.deserializers.GlueSchemaRegistryKafkaDeserializer;
import com.amazonaws.services.schemaregistry.utils.AvroRecordType;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import org.opensearch.dataprepper.model.plugin.PluginConfigObservable;
import org.opensearch.dataprepper.plugins.kafka.authenticator.DynamicBasicCredentialsProvider;
import org.opensearch.dataprepper.plugins.kafka.authenticator.DynamicSaslClientCallbackHandler;
import org.opensearch.dataprepper.plugins.kafka.common.aws.AwsContext;
import org.opensearch.dataprepper.plugins.kafka.configuration.AuthConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.AwsConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.AwsIamAuthConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.EncryptionConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.EncryptionType;
import org.opensearch.dataprepper.plugins.kafka.configuration.KafkaConnectionConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.KafkaConsumerConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.OAuthConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.PlainTextAuthConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.SchemaConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.SchemaRegistryType;
import org.opensearch.dataprepper.plugins.kafka.configuration.ScramAuthConfig;
import org.opensearch.dataprepper.plugins.kafka.source.KafkaSourceConfig;
import org.opensearch.dataprepper.plugins.kafka.util.CustomClientSslEngineFactory;
import org.opensearch.dataprepper.plugins.kafka.util.InsecureSslEngineFactory;
import org.opensearch.dataprepper.plugins.kafka.util.KafkaClusterAuthConfig;
import org.slf4j.Logger;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.glue.model.Compatibility;
import software.amazon.awssdk.services.kafka.KafkaClient;
import software.amazon.awssdk.services.kafka.KafkaClientBuilder;
import software.amazon.awssdk.services.kafka.model.GetBootstrapBrokersRequest;
import software.amazon.awssdk.services.kafka.model.GetBootstrapBrokersResponse;
import software.amazon.awssdk.services.kafka.model.KafkaException;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import software.amazon.awssdk.services.sts.model.StsException;

public class KafkaSecurityConfigurer {
    private static final String SASL_MECHANISM = "sasl.mechanism";
    private static final String SECURITY_PROTOCOL = "security.protocol";
    private static final String SASL_JAAS_CONFIG = "sasl.jaas.config";
    private static final String SASL_CALLBACK_HANDLER_CLASS = "sasl.login.callback.handler.class";
    private static final String SASL_CLIENT_CALLBACK_HANDLER_CLASS = "sasl.client.callback.handler.class";
    private static final String SASL_JWKS_ENDPOINT_URL = "sasl.oauthbearer.jwks.endpoint.url";
    private static final String SASL_TOKEN_ENDPOINT_URL = "sasl.oauthbearer.token.endpoint.url";
    private static final String PLAINTEXT_JAASCONFIG = "org.apache.kafka.common.security.plain.PlainLoginModule required username= \"%s\" password=   \"%s\";";
    private static final String OAUTH_JAASCONFIG = "org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule required clientId='%s' clientSecret='%s' scope='%s' OAUTH_LOGIN_SERVER='%s' OAUTH_LOGIN_ENDPOINT='%s' OAUT_LOGIN_GRANT_TYPE=%s OAUTH_LOGIN_SCOPE=%s OAUTH_AUTHORIZATION='Basic %s';";
    private static final String INSTROSPECT_SERVER_PROPERTIES = " OAUTH_INTROSPECT_SERVER='%s' OAUTH_INTROSPECT_ENDPOINT='%s' OAUTH_INTROSPECT_AUTHORIZATION='Basic %s";
    private static final String PLAIN_MECHANISM = "PLAIN";
    private static final String OAUTHBEARER_MECHANISM = "OAUTHBEARER";
    private static final String SASL_PLAINTEXT_PROTOCOL = "SASL_PLAINTEXT";
    private static final String PLAINTEXT_PROTOCOL = "PLAINTEXT";
    private static final String REGISTRY_BASIC_AUTH_USER_INFO = "schema.registry.basic.auth.user.info";
    private static final int MAX_KAFKA_CLIENT_RETRIES = 360;
    private static final String SSL_ENGINE_FACTORY_CLASS = "ssl.engine.factory.class";
    private static final String CERTIFICATE_CONTENT = "certificateContent";
    private static final String SSL_TRUSTSTORE_LOCATION = "ssl.truststore.location";
    private static final String SSL_TRUSTSTORE_PASSWORD = "ssl.truststore.password";
    private static AwsCredentialsProvider mskCredentialsProvider;
    private static AwsCredentialsProvider awsGlueCredentialsProvider;
    private static GlueSchemaRegistryKafkaDeserializer glueDeserializer;

    private static void setPlainTextAuthProperties(Properties properties, PlainTextAuthConfig plainTextAuthConfig, EncryptionConfig encryptionConfig) {
        String username = plainTextAuthConfig.getUsername();
        String password = plainTextAuthConfig.getPassword();
        properties.put(SASL_MECHANISM, PLAIN_MECHANISM);
        properties.put(SASL_JAAS_CONFIG, "org.apache.kafka.common.security.plain.PlainLoginModule required username=\"" + username + "\" password=\"" + password + "\";");
        if (KafkaSecurityConfigurer.checkEncryptionType(encryptionConfig, EncryptionType.SSL)) {
            properties.put(SECURITY_PROTOCOL, "SASL_SSL");
            KafkaSecurityConfigurer.setSecurityProtocolSSLProperties(properties, encryptionConfig);
        } else {
            properties.put(SECURITY_PROTOCOL, SASL_PLAINTEXT_PROTOCOL);
        }
    }

    private static void setScramAuthProperties(Properties properties, ScramAuthConfig scramAuthConfig, EncryptionConfig encryptionConfig) {
        String username = scramAuthConfig.getUsername();
        String password = scramAuthConfig.getPassword();
        String mechanism = scramAuthConfig.getMechanism();
        properties.put(SASL_MECHANISM, mechanism);
        properties.put(SASL_JAAS_CONFIG, "org.apache.kafka.common.security.scram.ScramLoginModule required username=\"" + username + "\" password=\"" + password + "\";");
        if (KafkaSecurityConfigurer.checkEncryptionType(encryptionConfig, EncryptionType.SSL)) {
            properties.put(SECURITY_PROTOCOL, "SASL_SSL");
            KafkaSecurityConfigurer.setSecurityProtocolSSLProperties(properties, encryptionConfig);
        } else {
            properties.put(SECURITY_PROTOCOL, SASL_PLAINTEXT_PROTOCOL);
        }
    }

    private static void setSecurityProtocolSSLProperties(Properties properties, EncryptionConfig encryptionConfig) {
        if (Objects.nonNull(encryptionConfig.getCertificate())) {
            KafkaSecurityConfigurer.setCustomSslProperties(properties, encryptionConfig.getCertificate());
        } else if (Objects.nonNull(encryptionConfig.getTrustStoreFilePath()) && Objects.nonNull(encryptionConfig.getTrustStorePassword())) {
            KafkaSecurityConfigurer.setTruststoreProperties(properties, encryptionConfig);
        }
    }

    private static void setCustomSslProperties(Properties properties, String certificateContent) {
        properties.put(CERTIFICATE_CONTENT, certificateContent);
        properties.put(SSL_ENGINE_FACTORY_CLASS, CustomClientSslEngineFactory.class);
    }

    private static void setTruststoreProperties(Properties properties, EncryptionConfig encryptionConfig) {
        properties.put(SSL_TRUSTSTORE_LOCATION, encryptionConfig.getTrustStoreFilePath());
        properties.put(SSL_TRUSTSTORE_PASSWORD, encryptionConfig.getTrustStorePassword());
    }

    public static void setOauthProperties(KafkaClusterAuthConfig kafkaClusterAuthConfig, Properties properties) {
        OAuthConfig oAuthConfig = kafkaClusterAuthConfig.getAuthConfig().getSaslAuthConfig().getOAuthConfig();
        String oauthClientId = oAuthConfig.getOauthClientId();
        String oauthClientSecret = oAuthConfig.getOauthClientSecret();
        String oauthLoginServer = oAuthConfig.getOauthLoginServer();
        String oauthLoginEndpoint = oAuthConfig.getOauthLoginEndpoint();
        String oauthLoginGrantType = oAuthConfig.getOauthLoginGrantType();
        String oauthLoginScope = oAuthConfig.getOauthLoginScope();
        String oauthAuthorizationToken = Base64.getEncoder().encodeToString((oauthClientId + ":" + oauthClientSecret).getBytes());
        String oauthIntrospectEndpoint = oAuthConfig.getOauthIntrospectEndpoint();
        String tokenEndPointURL = oAuthConfig.getOauthTokenEndpointURL();
        String saslMechanism = oAuthConfig.getOauthSaslMechanism();
        String securityProtocol = oAuthConfig.getOauthSecurityProtocol();
        String loginCallBackHandler = oAuthConfig.getOauthSaslLoginCallbackHandlerClass();
        String oauthJwksEndpointURL = oAuthConfig.getOauthJwksEndpointURL();
        String introspectServer = oAuthConfig.getOauthIntrospectServer();
        properties.put(SASL_MECHANISM, saslMechanism);
        properties.put(SECURITY_PROTOCOL, securityProtocol);
        properties.put(SASL_TOKEN_ENDPOINT_URL, tokenEndPointURL);
        properties.put(SASL_CALLBACK_HANDLER_CLASS, loginCallBackHandler);
        if (oauthJwksEndpointURL != null && !oauthJwksEndpointURL.isEmpty() && !oauthJwksEndpointURL.isBlank()) {
            properties.put(SASL_JWKS_ENDPOINT_URL, oauthJwksEndpointURL);
        }
        String instrospect_properties = "";
        if (oauthJwksEndpointURL != null && !oauthIntrospectEndpoint.isBlank() && !oauthIntrospectEndpoint.isEmpty()) {
            instrospect_properties = String.format(INSTROSPECT_SERVER_PROPERTIES, introspectServer, oauthIntrospectEndpoint, oauthAuthorizationToken);
        }
        Object jass_config = String.format(OAUTH_JAASCONFIG, oauthClientId, oauthClientSecret, oauthLoginScope, oauthLoginServer, oauthLoginEndpoint, oauthLoginGrantType, oauthLoginScope, oauthAuthorizationToken, instrospect_properties);
        if (kafkaClusterAuthConfig instanceof KafkaSourceConfig && "USER_INFO".equalsIgnoreCase(((KafkaSourceConfig)kafkaClusterAuthConfig).getSchemaConfig().getBasicAuthCredentialsSource())) {
            SchemaConfig schemaConfig = ((KafkaSourceConfig)kafkaClusterAuthConfig).getSchemaConfig();
            String apiKey = schemaConfig.getSchemaRegistryApiKey();
            String apiSecret = schemaConfig.getSchemaRegistryApiSecret();
            String extensionLogicalCluster = oAuthConfig.getExtensionLogicalCluster();
            String extensionIdentityPoolId = oAuthConfig.getExtensionIdentityPoolId();
            properties.put(REGISTRY_BASIC_AUTH_USER_INFO, apiKey + ":" + apiSecret);
            properties.put("basic.auth.credentials.source", "USER_INFO");
            String extensionValue = "extension_logicalCluster= \"%s\" extension_identityPoolId=   \"%s\";";
            jass_config = ((String)jass_config).replace(";", " ");
            jass_config = (String)jass_config + String.format(extensionValue, extensionLogicalCluster, extensionIdentityPoolId);
        }
        properties.put(SASL_JAAS_CONFIG, jass_config);
    }

    public static void setAwsIamAuthProperties(Properties properties, AwsIamAuthConfig awsIamAuthConfig, AwsConfig awsConfig) {
        properties.put(SECURITY_PROTOCOL, "SASL_SSL");
        properties.put(SASL_MECHANISM, "AWS_MSK_IAM");
        properties.put(SASL_CLIENT_CALLBACK_HANDLER_CLASS, "software.amazon.msk.auth.iam.IAMClientCallbackHandler");
        if (awsIamAuthConfig == AwsIamAuthConfig.ROLE) {
            if (Objects.isNull(awsConfig)) {
                throw new RuntimeException("AWS Config needs to be specified when sasl/aws_msk_iam is set to \"role\"");
            }
            Object baseIamAuthConfig = "software.amazon.msk.auth.iam.IAMLoginModule required awsRoleArn=\"%s\" awsStsRegion=\"%s\"";
            baseIamAuthConfig = String.format((String)baseIamAuthConfig, awsConfig.getStsRoleArn(), awsConfig.getRegion());
            if (Objects.nonNull(awsConfig.getStsRoleSessionName())) {
                baseIamAuthConfig = (String)baseIamAuthConfig + String.format(" awsRoleSessionName=\"%s\"", awsConfig.getStsRoleSessionName());
            }
            baseIamAuthConfig = (String)baseIamAuthConfig + ";";
            properties.put(SASL_JAAS_CONFIG, baseIamAuthConfig);
        } else if (awsIamAuthConfig == AwsIamAuthConfig.DEFAULT) {
            properties.put(SASL_JAAS_CONFIG, "software.amazon.msk.auth.iam.IAMLoginModule required;");
        }
    }

    private static void configureMSKCredentialsProvider(AuthConfig authConfig, AwsConfig awsConfig) {
        mskCredentialsProvider = DefaultCredentialsProvider.create();
        if (Objects.nonNull(authConfig) && Objects.nonNull(authConfig.getSaslAuthConfig()) && authConfig.getSaslAuthConfig().getAwsIamAuthConfig() == AwsIamAuthConfig.ROLE) {
            String sessionName = "data-prepper-kafka-session" + String.valueOf(UUID.randomUUID());
            StsClient stsClient = (StsClient)((StsClientBuilder)((StsClientBuilder)StsClient.builder().region(Region.of((String)awsConfig.getRegion()))).credentialsProvider(mskCredentialsProvider)).build();
            AssumeRoleRequest.Builder assumeRequestBuilder = AssumeRoleRequest.builder().roleArn(awsConfig.getStsRoleArn()).roleSessionName(sessionName);
            Map<String, String> headers = awsConfig.getAwsStsHeaderOverrides();
            if (Objects.nonNull(headers)) {
                assumeRequestBuilder.overrideConfiguration(configuration -> headers.forEach((arg_0, arg_1) -> ((AwsRequestOverrideConfiguration.Builder)configuration).putHeader(arg_0, arg_1)));
            }
            mskCredentialsProvider = ((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().stsClient(stsClient)).refreshRequest((AssumeRoleRequest)assumeRequestBuilder.build()).build();
        }
    }

    public static String getBootStrapServersForMsk(AwsConfig awsConfig, AwsCredentialsProvider mskCredentialsProvider, Logger log) {
        boolean retryable;
        AwsConfig.AwsMskConfig awsMskConfig = awsConfig.getAwsMskConfig();
        KafkaClient kafkaClient = (KafkaClient)((KafkaClientBuilder)((KafkaClientBuilder)KafkaClient.builder().credentialsProvider(mskCredentialsProvider)).region(Region.of((String)awsConfig.getRegion()))).build();
        GetBootstrapBrokersRequest request = (GetBootstrapBrokersRequest)GetBootstrapBrokersRequest.builder().clusterArn(awsMskConfig.getArn()).build();
        int numRetries = 0;
        GetBootstrapBrokersResponse result = null;
        do {
            retryable = false;
            try {
                result = kafkaClient.getBootstrapBrokers(request);
            }
            catch (KafkaException | StsException e) {
                log.info("Failed to get bootstrap server information from MSK. Will try every 10 seconds for {} seconds", (Object)3600, (Object)e);
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                retryable = true;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to get bootstrap server information from MSK.", e);
            }
        } while (retryable && numRetries++ < 360);
        if (Objects.isNull(result)) {
            throw new RuntimeException("Failed to get bootstrap server information from MSK after trying multiple times with retryable exceptions.");
        }
        switch (awsMskConfig.getBrokerConnectionType()) {
            case PUBLIC: {
                return result.bootstrapBrokerStringPublicSaslIam();
            }
            case MULTI_VPC: {
                return result.bootstrapBrokerStringVpcConnectivitySaslIam();
            }
        }
        return result.bootstrapBrokerStringSaslIam();
    }

    public static void setDynamicSaslClientCallbackHandler(Properties properties, KafkaConnectionConfig kafkaConnectionConfig, PluginConfigObservable pluginConfigObservable) {
        AuthConfig.SaslAuthConfig saslAuthConfig;
        AuthConfig authConfig = kafkaConnectionConfig.getAuthConfig();
        if (Objects.nonNull(authConfig) && Objects.nonNull(saslAuthConfig = authConfig.getSaslAuthConfig()) && Objects.nonNull(saslAuthConfig.getPlainTextAuthConfig())) {
            DynamicBasicCredentialsProvider dynamicBasicCredentialsProvider = DynamicBasicCredentialsProvider.getInstance();
            pluginConfigObservable.addPluginConfigObserver(newConfig -> dynamicBasicCredentialsProvider.refresh((KafkaConnectionConfig)newConfig));
            dynamicBasicCredentialsProvider.refresh(kafkaConnectionConfig);
            properties.put(SASL_CLIENT_CALLBACK_HANDLER_CLASS, DynamicSaslClientCallbackHandler.class);
        }
    }

    public static void setAuthProperties(Properties properties, KafkaClusterAuthConfig kafkaClusterAuthConfig, Logger log) {
        AwsConfig awsConfig = kafkaClusterAuthConfig.getAwsConfig();
        AuthConfig authConfig = kafkaClusterAuthConfig.getAuthConfig();
        EncryptionConfig encryptionConfig = kafkaClusterAuthConfig.getEncryptionConfig();
        KafkaSecurityConfigurer.configureMSKCredentialsProvider(authConfig, awsConfig);
        String bootstrapServers = "";
        if (Objects.nonNull(kafkaClusterAuthConfig.getBootstrapServers())) {
            bootstrapServers = String.join((CharSequence)",", kafkaClusterAuthConfig.getBootstrapServers());
        }
        if (Objects.nonNull(awsConfig) && Objects.nonNull(awsConfig.getAwsMskConfig())) {
            bootstrapServers = KafkaSecurityConfigurer.getBootStrapServersForMsk(awsConfig, mskCredentialsProvider, log);
        }
        if (Objects.nonNull(authConfig)) {
            AuthConfig.SaslAuthConfig saslAuthConfig = authConfig.getSaslAuthConfig();
            if (Objects.nonNull(saslAuthConfig)) {
                AwsIamAuthConfig awsIamAuthConfig = saslAuthConfig.getAwsIamAuthConfig();
                ScramAuthConfig scramAuthConfig = saslAuthConfig.getScramAuthConfig();
                PlainTextAuthConfig plainTextAuthConfig = saslAuthConfig.getPlainTextAuthConfig();
                if (Objects.nonNull((Object)awsIamAuthConfig)) {
                    if (KafkaSecurityConfigurer.checkEncryptionType(encryptionConfig, EncryptionType.NONE)) {
                        throw new RuntimeException("Encryption Config must be SSL to use IAM authentication mechanism");
                    }
                    KafkaSecurityConfigurer.setAwsIamAuthProperties(properties, awsIamAuthConfig, awsConfig);
                } else if (Objects.nonNull(saslAuthConfig.getOAuthConfig())) {
                    KafkaSecurityConfigurer.setOauthProperties(kafkaClusterAuthConfig, properties);
                } else if (Objects.nonNull(scramAuthConfig) && Objects.nonNull(kafkaClusterAuthConfig.getEncryptionConfig())) {
                    KafkaSecurityConfigurer.setScramAuthProperties(properties, scramAuthConfig, kafkaClusterAuthConfig.getEncryptionConfig());
                } else if (Objects.nonNull(plainTextAuthConfig) && Objects.nonNull(kafkaClusterAuthConfig.getEncryptionConfig())) {
                    KafkaSecurityConfigurer.setPlainTextAuthProperties(properties, plainTextAuthConfig, kafkaClusterAuthConfig.getEncryptionConfig());
                } else {
                    throw new RuntimeException("No SASL auth config specified");
                }
            }
            if (encryptionConfig.getInsecure()) {
                properties.put(SSL_ENGINE_FACTORY_CLASS, InsecureSslEngineFactory.class);
            }
        }
        if ((Objects.isNull(authConfig) || Objects.isNull(authConfig.getSaslAuthConfig())) && KafkaSecurityConfigurer.checkEncryptionType(encryptionConfig, EncryptionType.SSL)) {
            properties.put(SECURITY_PROTOCOL, "SSL");
            KafkaSecurityConfigurer.setSecurityProtocolSSLProperties(properties, encryptionConfig);
        }
        if (Objects.isNull(bootstrapServers) || bootstrapServers.isEmpty()) {
            throw new RuntimeException("Bootstrap servers are not specified");
        }
        properties.put("bootstrap.servers", bootstrapServers);
    }

    private static boolean checkEncryptionType(EncryptionConfig encryptionConfig, EncryptionType encryptionType) {
        return Objects.nonNull(encryptionConfig) && encryptionConfig.getType() == encryptionType;
    }

    public static GlueSchemaRegistryKafkaDeserializer getGlueSerializer(KafkaConsumerConfig kafkaConsumerConfig, AwsContext awsContext) {
        AwsConfig awsConfig = kafkaConsumerConfig.getAwsConfig();
        awsGlueCredentialsProvider = awsContext.getOrDefault(awsConfig);
        SchemaConfig schemaConfig = kafkaConsumerConfig.getSchemaConfig();
        if (Objects.isNull(schemaConfig) || schemaConfig.getType() != SchemaRegistryType.AWS_GLUE) {
            return null;
        }
        HashMap<String, String> configs = new HashMap<String, String>();
        Region region = awsContext.getRegionOrDefault(awsConfig);
        if (Objects.nonNull(region)) {
            configs.put("region", region.id());
        }
        configs.put("avroRecordType", AvroRecordType.GENERIC_RECORD.getName());
        configs.put("timeToLiveMillis", "86400000");
        configs.put("cacheSize", "10");
        configs.put("compatibility", (String)Compatibility.FULL);
        String registryUrl = kafkaConsumerConfig.getSchemaConfig().getRegistryURL();
        boolean endpointOverride = kafkaConsumerConfig.getSchemaConfig().getOverrideEndpoint();
        if (endpointOverride) {
            configs.put("endpoint", registryUrl);
        }
        glueDeserializer = new GlueSchemaRegistryKafkaDeserializer(awsGlueCredentialsProvider, configs);
        return glueDeserializer;
    }
}

