/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.expression;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.opensearch.dataprepper.expression.ExpressionFunction;
import org.opensearch.dataprepper.model.event.Event;

@Named
public class ExpressionFunctionProvider {
    private Map<String, ExpressionFunction> expressionFunctionsMap;

    @Inject
    public ExpressionFunctionProvider(List<ExpressionFunction> expressionFunctions) {
        this.expressionFunctionsMap = expressionFunctions.stream().collect(Collectors.toMap(e -> e.getFunctionName(), e -> e));
    }

    public Object provideFunction(String functionName, List<Object> argList, Event event, Function<Object, Object> convertLiteralType) {
        if (!this.expressionFunctionsMap.containsKey(functionName)) {
            throw new RuntimeException("Unknown function in the expression");
        }
        return this.expressionFunctionsMap.get(functionName).evaluate(argList, event, convertLiteralType);
    }
}

