/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.dynamodb.export;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.opensearch.dataprepper.plugins.source.dynamodb.export.S3ObjectReader;
import org.opensearch.dataprepper.plugins.source.dynamodb.model.ExportSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestFileReader {
    private static final Logger LOG = LoggerFactory.getLogger(ManifestFileReader.class);
    private static final TypeReference<Map<String, String>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, String>>(){};
    private static final String DATA_FILE_S3_KEY = "dataFileS3Key";
    private static final String DATA_FILE_ITEM_COUNT_KEY = "itemCount";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final S3ObjectReader objectReader;

    public ManifestFileReader(S3ObjectReader objectReader) {
        this.objectReader = objectReader;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public ExportSummary parseSummaryFile(String bucket, String key) {
        LOG.debug("Try to read the manifest summary file");
        try (InputStream object = this.objectReader.readFile(bucket, key);){
            ExportSummary exportSummary;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(object));){
                ExportSummary summaryInfo;
                String line = reader.readLine();
                LOG.debug("Manifest summary: {}", (Object)line);
                exportSummary = summaryInfo = (ExportSummary)MAPPER.readValue(line, ExportSummary.class);
            }
            return exportSummary;
        }
        catch (Exception e) {
            LOG.error("Failed to parse the summary info due to {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public Map<String, Integer> parseDataFile(String bucket, String key) {
        LOG.info("Try to read the manifest data file");
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        try (InputStream object = this.objectReader.readFile(bucket, key);
             BufferedReader reader = new BufferedReader(new InputStreamReader(object));){
            String line;
            while ((line = reader.readLine()) != null) {
                Map map = (Map)MAPPER.readValue(line, MAP_TYPE_REFERENCE);
                LOG.info("Export data file: {} with item count {}", map.get(DATA_FILE_S3_KEY), map.get(DATA_FILE_ITEM_COUNT_KEY));
                result.put((String)map.get(DATA_FILE_S3_KEY), Integer.valueOf((String)map.get(DATA_FILE_ITEM_COUNT_KEY)));
            }
        }
        catch (Exception e) {
            LOG.error("Exception due to {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        return result;
    }
}

