/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.mutateevent;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.regex.Pattern;
import org.opensearch.dataprepper.common.TransformOption;
import org.opensearch.dataprepper.model.annotations.AlsoRequired;
import org.opensearch.dataprepper.model.annotations.ExampleValues;
import org.opensearch.dataprepper.model.annotations.ValidRegex;
import org.opensearch.dataprepper.model.event.EventKey;
import org.opensearch.dataprepper.model.event.EventKeyConfiguration;
import org.opensearch.dataprepper.model.event.EventKeyFactory;

@JsonPropertyOrder
@JsonClassDescription(value="The <code>rename_keys</code> processor renames keys in an event.")
public class RenameKeyProcessorConfig {
    @Valid
    @AlsoRequired(values={@AlsoRequired.Required(name="transform_key", allowedValues={"null", "none"})})
    private List<Entry> entries;
    @JsonProperty(value="transform_key", defaultValue="none")
    @JsonPropertyDescription(value="Allows transforming the key's name such as making the name all lowercase.")
    @AlsoRequired(values={@AlsoRequired.Required(name="entries", allowedValues={"null"})})
    private TransformOption transformOption = TransformOption.NONE;

    public List<Entry> getEntries() {
        return this.entries;
    }

    public TransformOption getTransformOption() {
        return this.transformOption;
    }

    @AssertTrue(message="entries and transform_key are mutually exclusive options. entries or transform_key is required.")
    @AssertTrue(message="entries and transform_key are mutually exclusive options. entries or transform_key is required.") boolean isValidConfig() {
        return (this.transformOption != null && this.transformOption != TransformOption.NONE) ^ this.entries != null;
    }

    @JsonPropertyOrder
    public static class Entry {
        static final String FROM_KEY = "from_key";
        static final String FROM_KEY_REGEX = "from_key_regex";
        @JsonProperty(defaultValue="from_key")
        @JsonPropertyDescription(value="The key of the entry to be renamed. This field cannot be defined along with <code>from_key_regex</code>.")
        @AlsoRequired(values={@AlsoRequired.Required(name="from_key_regex", allowedValues={"null"})})
        @EventKeyConfiguration(value={EventKeyFactory.EventAction.GET, EventKeyFactory.EventAction.DELETE})
        private EventKey fromKey;
        @ValidRegex(message="The value of from_key_regex is not a valid regex string")
        @JsonProperty(defaultValue="from_key_regex")
        @JsonPropertyDescription(value="The regex pattern of the key of the entry to be renamed. This field cannot be defined along with <code>from_key</code>.")
        @ExampleValues(value={@ExampleValues.Example(value="regex", description="Generic regex string.")})
        @AlsoRequired(values={@AlsoRequired.Required(name="from_key", allowedValues={"null"})})
        private String fromKeyRegex;
        @NotEmpty
        @NotNull
        @JsonProperty(value="to_key")
        @JsonPropertyDescription(value="The new key of the entry.")
        @EventKeyConfiguration(value={EventKeyFactory.EventAction.PUT})
        private EventKey toKey;
        @JsonProperty(value="overwrite_if_to_key_exists")
        @JsonPropertyDescription(value="When set to true, the existing value is overwritten if key already exists in the event. The default value is false.")
        private boolean overwriteIfToKeyExists = false;
        @JsonProperty(value="rename_when")
        @JsonPropertyDescription(value="A <a href=\"https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/\">conditional expression</a> that will be evaluated to determine whether the processor will be run on the event. By default, all events will be processed if no condition is provided.")
        @ExampleValues(value={@ExampleValues.Example(value="startsWith(/path, \"https://\")", description="Rename the string only if it starts with an HTTPS scheme.")})
        private String renameWhen;
        private Pattern fromKeyCompiledPattern;

        public EventKey getFromKey() {
            return this.fromKey;
        }

        public String getFromKeyPattern() {
            return this.fromKeyRegex;
        }

        public EventKey getToKey() {
            return this.toKey;
        }

        public boolean getOverwriteIfToKeyExists() {
            return this.overwriteIfToKeyExists;
        }

        public String getRenameWhen() {
            return this.renameWhen;
        }

        @JsonIgnore
        public Pattern getFromKeyCompiledPattern() {
            if (this.fromKeyRegex != null && this.fromKeyCompiledPattern == null) {
                this.fromKeyCompiledPattern = Pattern.compile(this.fromKeyRegex);
            }
            return this.fromKeyCompiledPattern;
        }

        public Entry(EventKey fromKey, String fromKeyPattern, EventKey toKey, boolean overwriteIfKeyExists, String renameWhen) {
            this.fromKey = fromKey;
            this.fromKeyRegex = fromKeyPattern;
            this.toKey = toKey;
            this.overwriteIfToKeyExists = overwriteIfKeyExists;
            this.renameWhen = renameWhen;
        }

        public Entry() {
        }
    }
}

