/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.source_crawler.utils.retry;

import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.plugins.source.source_crawler.utils.retry.RetryStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;

public class RetryAfterHeaderStrategy
implements RetryStrategy {
    private static final Logger log = LoggerFactory.getLogger(RetryAfterHeaderStrategy.class);
    private static final String RATE_LIMIT_REMAINING = "X-RateLimit-Remaining";
    private static final String RATE_LIMIT_RESET = "X-RateLimit-Reset";
    private static final String RETRY_AFTER = "Retry-After";
    private static final List<HttpStatus> DEFAULT_RATE_LIMIT_STATUS_CODES = Arrays.asList(HttpStatus.TOO_MANY_REQUESTS);
    private final List<Integer> retryAttemptSleepTime = RetryStrategy.DEFAULT_RETRY_ATTEMPT_SLEEP_TIME;
    private final List<Integer> rateLimitRetrySleepTime;
    private final List<HttpStatus> rateLimitStatusCodes;
    private final int maxRetries;

    public RetryAfterHeaderStrategy() {
        this.rateLimitRetrySleepTime = RetryStrategy.DEFAULT_RATE_LIMIT_RETRY_SLEEP_TIME;
        this.rateLimitStatusCodes = DEFAULT_RATE_LIMIT_STATUS_CODES;
        this.maxRetries = RetryStrategy.MAX_RETRIES;
    }

    public RetryAfterHeaderStrategy(int maxRetries) {
        this.rateLimitRetrySleepTime = RetryStrategy.DEFAULT_RATE_LIMIT_RETRY_SLEEP_TIME;
        this.rateLimitStatusCodes = DEFAULT_RATE_LIMIT_STATUS_CODES;
        this.maxRetries = maxRetries;
    }

    public RetryAfterHeaderStrategy(List<Integer> rateLimitRetrySleepTime, List<HttpStatus> rateLimitStatusCodes) {
        this.rateLimitRetrySleepTime = rateLimitRetrySleepTime != null ? rateLimitRetrySleepTime : RetryStrategy.DEFAULT_RATE_LIMIT_RETRY_SLEEP_TIME;
        this.rateLimitStatusCodes = rateLimitStatusCodes != null ? rateLimitStatusCodes : DEFAULT_RATE_LIMIT_STATUS_CODES;
        this.maxRetries = this.rateLimitRetrySleepTime.size();
    }

    @Override
    public long calculateSleepTime(Exception ex, int retryCount) {
        Optional<Integer> retryAfterSeconds;
        Optional<HttpStatus> statusCode = RetryStrategy.getStatusCode(ex);
        if (statusCode.isPresent() && this.isRateLimited(statusCode.get()) && (retryAfterSeconds = this.extractRetryAfterHeader(ex)).isPresent()) {
            log.info("Using retry-after header value: {} seconds (attempt {}/{})", new Object[]{retryAfterSeconds.get(), retryCount + 1, this.getMaxRetries()});
            return retryAfterSeconds.get() * 1000;
        }
        List<Integer> sleepTimes = statusCode.isPresent() && this.isRateLimited(statusCode.get()) ? this.rateLimitRetrySleepTime : this.retryAttemptSleepTime;
        int sleepTimeSeconds = retryCount < sleepTimes.size() ? sleepTimes.get(retryCount) : sleepTimes.get(sleepTimes.size() - 1);
        log.debug("Retrying in {} seconds (attempt {}/{})", new Object[]{sleepTimeSeconds, retryCount + 1, this.getMaxRetries()});
        return sleepTimeSeconds * 1000;
    }

    @Override
    public int getMaxRetries() {
        return this.maxRetries;
    }

    private boolean isRateLimited(HttpStatus status) {
        return this.rateLimitStatusCodes.contains(status);
    }

    private Optional<Integer> extractRetryAfterHeader(Exception ex) {
        try {
            String retryAfter;
            HttpHeaders headers = null;
            if (ex instanceof HttpClientErrorException) {
                headers = ((HttpClientErrorException)((Object)ex)).getResponseHeaders();
            } else if (ex instanceof HttpServerErrorException) {
                headers = ((HttpServerErrorException)((Object)ex)).getResponseHeaders();
            }
            if (headers != null && headers.containsKey((Object)RETRY_AFTER) && (retryAfter = headers.getFirst(RETRY_AFTER)) != null) {
                int seconds = Integer.parseInt(retryAfter);
                return Optional.of(Math.max(seconds, 1));
            }
            if (headers != null && headers.containsKey((Object)RATE_LIMIT_REMAINING) && headers.containsKey((Object)RATE_LIMIT_RESET)) {
                String xRateLimitRemaining = headers.getFirst(RATE_LIMIT_REMAINING);
                String resetEpoch = headers.getFirst(RATE_LIMIT_RESET);
                if (xRateLimitRemaining != null && xRateLimitRemaining.equals("0") && resetEpoch != null && !resetEpoch.isBlank()) {
                    long resetSeconds = Long.parseLong(resetEpoch);
                    long nowSeconds = Instant.now().getEpochSecond();
                    long wait = resetSeconds - nowSeconds + 1L;
                    return Optional.of((int)Math.max(wait, 1L));
                }
            }
        }
        catch (NumberFormatException e) {
            log.warn(DataPrepperMarkers.NOISY, "Failed to parse retry-after header: {}", (Object)e.getMessage());
        }
        return Optional.empty();
    }
}

