/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.source_crawler.utils.retry;

import java.util.Optional;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.plugins.source.source_crawler.utils.retry.RetryDecision;
import org.opensearch.dataprepper.plugins.source.source_crawler.utils.retry.RetryStrategy;
import org.opensearch.dataprepper.plugins.source.source_crawler.utils.retry.StatusCodeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class DefaultStatusCodeHandler
implements StatusCodeHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultStatusCodeHandler.class);

    @Override
    public RetryDecision handleStatusCode(Exception ex, int retryCount, Runnable credentialRenewal) {
        Optional<HttpStatus> statusCode = RetryStrategy.getStatusCode(ex);
        String statusMessage = ex.getMessage();
        if (statusCode.isEmpty()) {
            return RetryDecision.stop();
        }
        switch (statusCode.get()) {
            case UNAUTHORIZED: {
                log.error(DataPrepperMarkers.NOISY, "Token expired. Attempting to renew credentials.", (Throwable)ex);
                credentialRenewal.run();
                return RetryDecision.retry();
            }
            case FORBIDDEN: {
                log.error(DataPrepperMarkers.NOISY, "Access forbidden: {}", (Object)statusMessage, (Object)ex);
                return RetryDecision.stopWithException(new SecurityException("Access forbidden: " + statusMessage));
            }
            case NOT_FOUND: {
                log.warn(DataPrepperMarkers.NOISY, "Resource not found (404): {}. This is expected for deleted/expired resources.", (Object)statusMessage);
                return RetryDecision.stop();
            }
            case TOO_MANY_REQUESTS: {
                log.error(DataPrepperMarkers.NOISY, "Hitting API rate limit. Backing off.", (Throwable)ex);
                return RetryDecision.retry();
            }
            case SERVICE_UNAVAILABLE: {
                log.error(DataPrepperMarkers.NOISY, "Service unavailable. Will retry.", (Throwable)ex);
                return RetryDecision.retry();
            }
        }
        if (statusCode.get().is4xxClientError()) {
            log.error(DataPrepperMarkers.NOISY, "Client error: {}. Will not retry.", statusCode, (Object)ex);
            return RetryDecision.stop();
        }
        if (statusCode.get().is5xxServerError()) {
            log.error(DataPrepperMarkers.NOISY, "Server error: {}. Will retry.", statusCode, (Object)ex);
            return RetryDecision.retry();
        }
        log.error(DataPrepperMarkers.NOISY, "Unexpected status code: {}. Will not retry.", statusCode, (Object)ex);
        return RetryDecision.stop();
    }
}

